/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.physical;

import java.util.logging.Logger;
import org.goplanit.graph.directed.DirectedEdgeImpl;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.layer.physical.Link;

public class LinkImpl<N extends DirectedVertex, LS extends EdgeSegment>
extends DirectedEdgeImpl<N, LS>
implements Link {
    private static final long serialVersionUID = 2360017879557363410L;
    private static final Logger LOGGER = Logger.getLogger(LinkImpl.class.getCanonicalName());
    protected long linkId;

    protected static long generateLinkId(IdGroupingToken tokenId) {
        return IdGenerator.generateId((IdGroupingToken)tokenId, (Class)LINK_ID_CLASS);
    }

    protected void setLinkId(long linkId) {
        this.linkId = linkId;
    }

    protected long recreateLinkId(IdGroupingToken tokenId) {
        long newLinkId = LinkImpl.generateLinkId(tokenId);
        this.setLinkId(newLinkId);
        return newLinkId;
    }

    protected LinkImpl(LinkImpl<N, LS> other, boolean deepCopy) {
        super(other, deepCopy);
        this.setLinkId(other.getLinkId());
    }

    protected LinkImpl(IdGroupingToken groupId, N nodeA, N nodeB) {
        super(groupId, nodeA, nodeB);
        this.setLinkId(LinkImpl.generateLinkId(groupId));
    }

    protected LinkImpl(IdGroupingToken groupId, N nodeA, N nodeB, double length) {
        super(groupId, nodeA, nodeB, length);
        this.setLinkId(LinkImpl.generateLinkId(groupId));
    }

    public long getLinkId() {
        return this.linkId;
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        this.recreateLinkId(tokenId);
        return super.recreateManagedIds(tokenId);
    }

    @Override
    public LinkImpl<N, LS> shallowClone() {
        return new LinkImpl<N, LS>(this, false);
    }

    @Override
    public LinkImpl<N, LS> deepClone() {
        return new LinkImpl<N, LS>(this, true);
    }

    @Override
    public boolean validate() {
        if (super.validate() && this.getGeometry() != null) {
            if (!this.getNodeA().getPosition().getCoordinate().equals2D(this.getGeometry().getCoordinateN(0), 1.0E-6)) {
                return false;
            }
            if (!this.getNodeB().getPosition().getCoordinate().equals2D(this.getGeometry().getCoordinateN(this.getGeometry().getNumPoints() - 1), 1.0E-6)) {
                LOGGER.warning(String.format("link (id:%d externalId:%s) geometry inconsistent with extreme node B", this.getId(), this.getExternalId()));
                return false;
            }
        }
        return false;
    }
}

