/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.physical;

import java.util.logging.Logger;
import org.goplanit.graph.GraphEntityFactoryImpl;
import org.goplanit.network.layer.physical.LinkImpl;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.physical.LinkFactory;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.physical.Links;
import org.goplanit.utils.network.layer.physical.Node;

public class LinkFactoryImpl
extends GraphEntityFactoryImpl<Link>
implements LinkFactory<Link> {
    private static final Logger LOGGER = Logger.getLogger(LinkFactoryImpl.class.getCanonicalName());

    public LinkFactoryImpl(IdGroupingToken groupIdToken, Links<? extends Link> links) {
        super(groupIdToken, links);
    }

    public LinkImpl<Node, LinkSegment> registerNew(Node nodeA, Node nodeB, double lengthKm, boolean registerOnNodes) {
        if (nodeA == null || nodeB == null) {
            LOGGER.warning("Unable to create new link, one or more of its nodes are not defined");
            return null;
        }
        LinkImpl<Node, LinkSegment> newLink = new LinkImpl<Node, LinkSegment>(this.getIdGroupingToken(), nodeA, nodeB);
        this.getGraphEntities().register(newLink);
        newLink.setLengthKm(lengthKm);
        if (registerOnNodes) {
            nodeA.addEdge(newLink);
            nodeB.addEdge(newLink);
        }
        return newLink;
    }
}

