/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.physical;

import java.util.logging.Logger;
import org.goplanit.graph.GraphEntityFactoryImpl;
import org.goplanit.network.layer.physical.ConjugateLinkSegmentImpl;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.network.layer.physical.ConjugateLink;
import org.goplanit.utils.network.layer.physical.ConjugateLinkSegment;
import org.goplanit.utils.network.layer.physical.ConjugateLinkSegmentFactory;
import org.goplanit.utils.network.layer.physical.ConjugateLinkSegments;

public class ConjugateLinkSegmentFactoryImpl
extends GraphEntityFactoryImpl<ConjugateLinkSegment>
implements ConjugateLinkSegmentFactory {
    private static final Logger LOGGER = Logger.getLogger(ConjugateLinkSegmentFactoryImpl.class.getCanonicalName());

    protected ConjugateLinkSegmentFactoryImpl(IdGroupingToken groupId, ConjugateLinkSegments container) {
        super(groupId, container);
    }

    public ConjugateLinkSegment create(ConjugateLink parent, boolean directionAb) {
        Pair originalEdgeSegments = parent.getOriginalAdjacentEdgeSegments(directionAb);
        if (originalEdgeSegments.anyIsNull()) {
            LOGGER.warning(String.format("Unable to create conjugate link segment on conjugate link %s (directionAb: %s)", parent.getXmlId(), Boolean.toString(directionAb)));
            return null;
        }
        ConjugateLinkSegmentImpl edgeSegment = new ConjugateLinkSegmentImpl(this.getIdGroupingToken(), parent, directionAb);
        return edgeSegment;
    }

    public ConjugateLinkSegment registerNew(ConjugateLink parent, boolean directionAb, boolean registerOnNodeAndLink) {
        ConjugateLinkSegment edgeSegment = this.create(parent, directionAb);
        this.getGraphEntities().register((Object)edgeSegment);
        if (registerOnNodeAndLink) {
            parent.registerEdgeSegment((EdgeSegment)edgeSegment, directionAb);
        }
        return edgeSegment;
    }
}

