/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.physical;

import java.util.logging.Logger;
import org.goplanit.graph.directed.DirectedEdgeImpl;
import org.goplanit.utils.graph.directed.ConjugateDirectedVertex;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.network.layer.physical.ConjugateLink;
import org.goplanit.utils.network.layer.physical.ConjugateLinkSegment;
import org.goplanit.utils.network.layer.physical.Link;
import org.locationtech.jts.geom.LineString;

public class ConjugateLinkImpl
extends DirectedEdgeImpl<ConjugateDirectedVertex, ConjugateLinkSegment>
implements ConjugateLink {
    private static final long serialVersionUID = 1017598997588544001L;
    private static final Logger LOGGER = Logger.getLogger(ConjugateLinkImpl.class.getCanonicalName());
    protected final Pair<Link, Link> originalLinks;

    protected ConjugateLinkImpl(ConjugateLinkImpl other, boolean deepCopy) {
        super(other, deepCopy);
        this.originalLinks = other.originalLinks.copy();
    }

    protected ConjugateLinkImpl(IdGroupingToken groupId, ConjugateDirectedVertex nodeA, ConjugateDirectedVertex nodeB, Link originalLink1, Link originalLink2) {
        super(groupId, nodeA, nodeB);
        this.originalLinks = Pair.of((Object)originalLink1, (Object)originalLink2);
    }

    @Override
    public double getLengthKm() {
        LOGGER.warning("Length of conjugate is combination of underlying original geometries/lengths, collect those instead, negative infinity returned");
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public void setLengthKm(double lengthInKm) {
        LOGGER.warning("Length of conjugate is combination of underlying original geometries/lengths, set those instead");
    }

    @Override
    public LineString getGeometry() {
        LOGGER.warning("Geometry of conjugate is combination of underlying original geometries, collect those instead, null returned");
        return null;
    }

    @Override
    public void setGeometry(LineString geometry) {
        LOGGER.warning("Geometry of conjugate is combination of underlying original geometries, set those instead");
    }

    @Override
    public ConjugateLinkImpl shallowClone() {
        return new ConjugateLinkImpl(this, false);
    }

    @Override
    public ConjugateLinkImpl deepClone() {
        return new ConjugateLinkImpl(this, true);
    }

    public Pair<? extends Link, ? extends Link> getOriginalAdjacentEdges() {
        return this.originalLinks;
    }
}

