/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.physical;

import java.util.logging.Logger;
import org.goplanit.graph.GraphEntityFactoryImpl;
import org.goplanit.network.layer.physical.ConjugateLinkImpl;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.GraphEntities;
import org.goplanit.utils.graph.directed.ConjugateDirectedVertex;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.layer.physical.ConjugateLink;
import org.goplanit.utils.network.layer.physical.ConjugateLinkFactory;
import org.goplanit.utils.network.layer.physical.Link;

public class ConjugateLinkFactoryImpl
extends GraphEntityFactoryImpl<ConjugateLink>
implements ConjugateLinkFactory {
    private static final Logger LOGGER = Logger.getLogger(ConjugateLinkFactoryImpl.class.getCanonicalName());

    public ConjugateLinkFactoryImpl(IdGroupingToken groupIdToken, GraphEntities<ConjugateLink> container) {
        super(groupIdToken, container);
    }

    public ConjugateLink registerNew(ConjugateDirectedVertex nodeA, ConjugateDirectedVertex nodeB, boolean registerOnNodes, Link originalLink1, Link originalLink2) {
        if (nodeA == null || nodeB == null) {
            LOGGER.warning("Unable to create new conjugate link, one or more of its conjugate nodes are not defined");
            return null;
        }
        ConjugateLinkImpl newLink = new ConjugateLinkImpl(this.getIdGroupingToken(), nodeA, nodeB, originalLink1, originalLink2);
        this.getGraphEntities().register((Object)newLink);
        if (registerOnNodes) {
            nodeA.addEdge((Edge)newLink);
            nodeB.addEdge((Edge)newLink);
        }
        return newLink;
    }
}

