/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.modifier;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.graph.directed.UntypedDirectedGraphImpl;
import org.goplanit.network.layer.modifier.UntypedNetworkLayerModifierImpl;
import org.goplanit.network.layer.service.ServiceNetworkLayerImpl;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.graph.directed.DirectedEdge;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.network.layer.modifier.ServiceNetworkLayerModifier;
import org.goplanit.utils.network.layer.service.ServiceLeg;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;
import org.goplanit.utils.network.layer.service.ServiceNode;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ServiceNetworkLayerModifierImpl<V extends ServiceNode, E extends ServiceLeg, S extends ServiceLegSegment>
extends UntypedNetworkLayerModifierImpl<V, E, S>
implements ServiceNetworkLayerModifier<V, E, S> {
    private static final Logger LOGGER = Logger.getLogger(ServiceNetworkLayerModifierImpl.class.getCanonicalName());
    private ServiceNetworkLayerImpl serviceNetworkLayer;

    public ServiceNetworkLayerModifierImpl(ServiceNetworkLayerImpl serviceNetworkLayer, UntypedDirectedGraphImpl<V, E, S> graph) {
        super(graph);
        this.serviceNetworkLayer = serviceNetworkLayer;
    }

    @Override
    public Map<Long, Pair<E, E>> breakAt(List<E> serviceLegsToBreak, V serviceNodeToBreakAt, CoordinateReferenceSystem crs) {
        throw new PlanItRunTimeException("Not yet implemented");
    }

    @Override
    public void removeDanglingSubnetworks(Integer belowSize, Integer aboveSize, boolean alwaysKeepLargest) {
        throw new PlanItRunTimeException("Not yet supported");
    }

    public void removeUnmappedServiceNetworkEntities() {
        UntypedDirectedGraphImpl graph = this.getUntypedDirectedGraph();
        String serviceLayerLoggingPrefix = LoggingUtils.serviceNetworkLayerPrefix((long)this.serviceNetworkLayer.getId());
        LOGGER.info(String.format("%s Removing GTFS based service network elements without a mapping to physical underlying network, likely due to being outside of network bounding box", serviceLayerLoggingPrefix));
        List<ServiceNode> toBeRemovedServiceNodes = graph.getVertices().stream().filter(v -> !v.hasPhysicalParentNodes()).collect(Collectors.toList());
        toBeRemovedServiceNodes.forEach(n -> this.graphModifier.removeVertex((DirectedVertex)n));
        LOGGER.info(String.format("%s Removed %d service nodes without a mapping to physical network", serviceLayerLoggingPrefix, toBeRemovedServiceNodes.size()));
        List<ServiceLegSegment> toBeRemovedServiceLegSegments = graph.getEdgeSegments().stream().filter(ls -> ls.getUpstreamServiceNode() == null || ls.getDownstreamServiceNode() == null || !ls.hasPhysicalParentSegments()).collect(Collectors.toList());
        toBeRemovedServiceLegSegments.forEach(ls -> this.graphModifier.removeEdgeSegment((EdgeSegment)ls));
        LOGGER.info(String.format("%s Removed %d service leg segments without a mapping to physical network", serviceLayerLoggingPrefix, toBeRemovedServiceLegSegments.size()));
        List<ServiceLeg> toBeRemovedServiceLegs = graph.getEdges().stream().filter(e -> e.getVertexA() == null || e.getVertexB() == null || !e.hasEdgeSegment()).collect(Collectors.toList());
        toBeRemovedServiceLegs.forEach(e -> this.graphModifier.removeEdge((DirectedEdge)e));
        LOGGER.info(String.format("%s Removed %d service legs without a mapping to physical network", serviceLayerLoggingPrefix, toBeRemovedServiceLegs.size()));
        this.graphModifier.recreateManagedEntitiesIds();
    }
}

