/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.macroscopic;

import java.util.function.Function;
import java.util.logging.Logger;
import org.goplanit.network.layer.macroscopic.ConjugateMacroscopicNetworkLayerImpl;
import org.goplanit.network.layer.macroscopic.MacroscopicLinkSegmentTypesImpl;
import org.goplanit.network.layer.macroscopic.MacroscopicLinkSegmentsImpl;
import org.goplanit.network.layer.macroscopic.MacroscopicLinksImpl;
import org.goplanit.network.layer.physical.NodesImpl;
import org.goplanit.network.layer.physical.UntypedPhysicalLayerImpl;
import org.goplanit.utils.graph.GraphEntityDeepCopyMapper;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.ManagedIdDeepCopyMapper;
import org.goplanit.utils.network.layer.ConjugateMacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLink;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentTypes;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegments;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinks;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.network.layer.physical.Nodes;
import org.goplanit.utils.network.virtual.ConjugateVirtualNetwork;

public class MacroscopicNetworkLayerImpl
extends UntypedPhysicalLayerImpl<Node, MacroscopicLink, MacroscopicLinkSegment>
implements MacroscopicNetworkLayer {
    private static final Logger LOGGER = Logger.getLogger(MacroscopicNetworkLayerImpl.class.getCanonicalName());
    public final MacroscopicLinkSegmentTypes linkSegmentTypes;

    protected MacroscopicNetworkLayerImpl(IdGroupingToken groupId) {
        this(groupId, new NodesImpl(groupId), new MacroscopicLinksImpl(groupId), new MacroscopicLinkSegmentsImpl(groupId));
    }

    protected MacroscopicNetworkLayerImpl(IdGroupingToken groupId, Nodes nodes, MacroscopicLinks links, MacroscopicLinkSegments linkSegments) {
        super(groupId, nodes, links, linkSegments);
        this.linkSegmentTypes = new MacroscopicLinkSegmentTypesImpl(groupId);
    }

    protected MacroscopicNetworkLayerImpl(MacroscopicNetworkLayerImpl other, boolean deepCopy, GraphEntityDeepCopyMapper<Node> nodeMapper, GraphEntityDeepCopyMapper<MacroscopicLink> linkMapper, GraphEntityDeepCopyMapper<MacroscopicLinkSegment> linkSegmentMapper, ManagedIdDeepCopyMapper<MacroscopicLinkSegmentType> linkSegmentTypeMapper) {
        super(other, deepCopy, nodeMapper, linkMapper, linkSegmentMapper);
        MacroscopicLinkSegmentTypes macroscopicLinkSegmentTypes = this.linkSegmentTypes = deepCopy ? other.linkSegmentTypes.deepCloneWithMapping(linkSegmentTypeMapper) : other.linkSegmentTypes.shallowClone();
        if (deepCopy) {
            this.updateLinkSegmentLinkSegmentTypes(ls -> (MacroscopicLinkSegmentType)linkSegmentTypeMapper.getMapping(ls), true);
        }
    }

    public void updateLinkSegmentLinkSegmentTypes(Function<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType> lsTypeToLsTypeMapping, boolean removeMissingMappings) {
        for (MacroscopicLinkSegment linkSegment : this.getLinkSegments()) {
            MacroscopicLinkSegmentType clonedType;
            if (linkSegment.getLinkSegmentType() == null || (clonedType = lsTypeToLsTypeMapping.apply(linkSegment.getLinkSegmentType())) == null && !removeMissingMappings) continue;
            linkSegment.setLinkSegmentType(clonedType);
        }
    }

    @Override
    public void logInfo(String prefix) {
        super.logInfo(prefix);
        LOGGER.info(String.format("%s#link segment types: %d", prefix, this.linkSegmentTypes.size()));
    }

    public MacroscopicLinkSegmentTypes getLinkSegmentTypes() {
        return this.linkSegmentTypes;
    }

    public MacroscopicLinks getLinks() {
        return (MacroscopicLinks)this.getDirectedGraph().getEdges();
    }

    public MacroscopicLinkSegments getLinkSegments() {
        return (MacroscopicLinkSegments)this.getDirectedGraph().getEdgeSegments();
    }

    public Nodes getNodes() {
        return (Nodes)this.getDirectedGraph().getVertices();
    }

    @Override
    public MacroscopicNetworkLayerImpl shallowClone() {
        return new MacroscopicNetworkLayerImpl(this, false, null, null, null, null);
    }

    @Override
    public MacroscopicNetworkLayerImpl deepClone() {
        return new MacroscopicNetworkLayerImpl(this, true, (GraphEntityDeepCopyMapper<Node>)new GraphEntityDeepCopyMapper(), (GraphEntityDeepCopyMapper<MacroscopicLink>)new GraphEntityDeepCopyMapper(), (GraphEntityDeepCopyMapper<MacroscopicLinkSegment>)new GraphEntityDeepCopyMapper(), (ManagedIdDeepCopyMapper<MacroscopicLinkSegmentType>)new ManagedIdDeepCopyMapper());
    }

    @Override
    public void reset() {
        super.reset();
        this.resetChildManagedIdEntities();
    }

    public void resetChildManagedIdEntities() {
        super.resetChildManagedIdEntities();
        this.linkSegmentTypes.reset();
    }

    public ConjugateMacroscopicNetworkLayer createConjugate(IdGroupingToken idToken, ConjugateVirtualNetwork conjugateVirtualNetwork) {
        ConjugateMacroscopicNetworkLayerImpl conjugateLayer = new ConjugateMacroscopicNetworkLayerImpl(idToken, this);
        conjugateLayer.update(conjugateVirtualNetwork);
        return conjugateLayer;
    }
}

