/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.macroscopic;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.PredefinedModeType;
import org.goplanit.utils.network.layer.macroscopic.AccessGroupProperties;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;

public class MacroscopicLinkSegmentTypeImpl
extends ExternalIdAbleImpl
implements MacroscopicLinkSegmentType {
    private static final Logger LOGGER = Logger.getLogger(MacroscopicLinkSegmentTypeImpl.class.getCanonicalName());
    protected String name;
    protected final Double capacityPerLanePcuHourLane;
    protected final Double maximumDensityPerLanePcuKmLane;
    protected Map<Mode, AccessGroupProperties> modeAccessProperties;

    protected void setId(long id) {
        super.setId(id);
    }

    protected static long generateId(IdGroupingToken idGroupingToken) {
        return IdGenerator.generateId((IdGroupingToken)idGroupingToken, (Class)MACROSCOPIC_LINK_SEGMENT_TYPE_ID_CLASS);
    }

    protected MacroscopicLinkSegmentTypeImpl(IdGroupingToken groupId, String name) {
        this(groupId, name, null, null);
    }

    protected MacroscopicLinkSegmentTypeImpl(IdGroupingToken groupId, String name, Double capacityPerLane) {
        this(groupId, name, capacityPerLane, null);
    }

    protected MacroscopicLinkSegmentTypeImpl(IdGroupingToken groupId, String name, Double capacityPerLane, Double maximumDensityPerLane) {
        super(MacroscopicLinkSegmentTypeImpl.generateId(groupId));
        this.setName(name);
        this.capacityPerLanePcuHourLane = capacityPerLane;
        this.maximumDensityPerLanePcuKmLane = maximumDensityPerLane;
        this.modeAccessProperties = new TreeMap<Mode, AccessGroupProperties>();
    }

    protected MacroscopicLinkSegmentTypeImpl(MacroscopicLinkSegmentTypeImpl other, boolean deepCopy) {
        super((ExternalIdAbleImpl)other);
        this.setName(other.getName());
        this.capacityPerLanePcuHourLane = other.getExplicitCapacityPerLane();
        this.maximumDensityPerLanePcuKmLane = other.getExplicitMaximumDensityPerLane();
        this.modeAccessProperties = new TreeMap<Mode, AccessGroupProperties>();
        TreeSet modesDone = new TreeSet();
        if (deepCopy) {
            for (Mode mode : other.getAllowedModes()) {
                if (modesDone.contains(mode)) continue;
                AccessGroupProperties clonedEntry = other.getAccessProperties(mode).deepClone();
                this.setAccessGroupProperties(clonedEntry);
                modesDone.addAll(clonedEntry.getAccessModes());
            }
        } else {
            this.modeAccessProperties.putAll(other.modeAccessProperties);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Double getExplicitCapacityPerLane() {
        return this.capacityPerLanePcuHourLane;
    }

    public Double getExplicitMaximumDensityPerLane() {
        return this.maximumDensityPerLanePcuKmLane;
    }

    public AccessGroupProperties getAccessProperties(Mode mode) {
        if (this.modeAccessProperties.containsKey(mode)) {
            return this.modeAccessProperties.get(mode);
        }
        return null;
    }

    public boolean isModeAllowed(Mode mode) {
        return this.modeAccessProperties.containsKey(mode);
    }

    public boolean isModeTypeAllowed(PredefinedModeType modeType) {
        return this.modeAccessProperties.entrySet().stream().anyMatch(entry -> ((Mode)entry.getKey()).isPredefinedModeType() && ((Mode)entry.getKey()).getPredefinedModeType().equals((Object)modeType));
    }

    public Set<Mode> getAllowedModes() {
        return this.modeAccessProperties.keySet();
    }

    public MacroscopicLinkSegmentTypeImpl shallowClone() {
        return new MacroscopicLinkSegmentTypeImpl(this, false);
    }

    public MacroscopicLinkSegmentTypeImpl deepClone() {
        return new MacroscopicLinkSegmentTypeImpl(this, true);
    }

    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = MacroscopicLinkSegmentTypeImpl.generateId(tokenId);
        this.setId(newId);
        return newId;
    }

    public void setAccessGroupProperties(Collection<AccessGroupProperties> accessProperties) {
        TreeSet processedModes = new TreeSet();
        for (AccessGroupProperties entry : accessProperties) {
            for (Mode mode : entry.getAccessModes()) {
                if (processedModes.contains(mode)) {
                    LOGGER.warning(String.format("Multiple provided access proprties on link segment type define the same mode (%s), ignoring all but first encountered", mode.getXmlId()));
                }
                this.modeAccessProperties.put(mode, entry);
            }
            processedModes.addAll(entry.getAccessModes());
        }
    }

    public void setAccessGroupProperties(AccessGroupProperties accessProperties) {
        for (Mode mode : accessProperties.getAccessModes()) {
            this.modeAccessProperties.put(mode, accessProperties);
        }
    }

    public void addAccessGroupProperties(AccessGroupProperties accessProperties) {
        if (this.findEqualAccessPropertiesForAnyMode(accessProperties) != null) {
            LOGGER.warning(String.format("IGNORE: Unable to register new access properties on link segment type %s, identical group already exist", this.getXmlId()));
        }
        this.setAccessGroupProperties(accessProperties);
    }

    public boolean removeModeAccess(Mode toBeRemovedMode) {
        AccessGroupProperties accessProperties = this.getAccessProperties(toBeRemovedMode);
        if (accessProperties == null) {
            return false;
        }
        boolean success = accessProperties.removeAccessMode(toBeRemovedMode);
        this.modeAccessProperties.remove(toBeRemovedMode);
        if (!accessProperties.hasAccessModes() && !this.hasAllowedModes()) {
            LOGGER.warning(String.format("Link segment type (%s) has no more supported modes, consider removing", this.getXmlId()));
        }
        return success;
    }

    public AccessGroupProperties findEqualAccessPropertiesForAnyMode(AccessGroupProperties accessProperties) {
        HashSet processedModes = new HashSet();
        for (AccessGroupProperties properties : this.modeAccessProperties.values()) {
            if (processedModes.contains(properties.getAccessModes().iterator().next())) continue;
            if (properties.isEqualExceptForModes(accessProperties)) {
                return properties;
            }
            processedModes.addAll(properties.getAccessModes());
        }
        return null;
    }

    public void registerModeOnAccessGroup(Mode accessMode, AccessGroupProperties accessGroupProperties) {
        if (this.findEqualAccessPropertiesForAnyMode(accessGroupProperties) == null) {
            LOGGER.warning(String.format("IGNORE: Unable to register new access mode on provided access group because access group does not exist on this link segment type (%s)", this.getXmlId()));
            return;
        }
        if (this.modeAccessProperties.containsKey(accessMode)) {
            LOGGER.warning(String.format("IGNORE: Unable to register new access mode on provided access group because mode is already registered on an access group for this link segment type (%s)", this.getXmlId()));
            return;
        }
        this.modeAccessProperties.put(accessMode, accessGroupProperties);
        accessGroupProperties.addAccessMode(accessMode);
    }

    public String toString() {
        return String.format("[%d,%s,%s]", this.getId(), this.getXmlId(), this.getName());
    }
}

