/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.macroscopic;

import java.util.logging.Logger;
import org.goplanit.graph.GraphEntityFactoryImpl;
import org.goplanit.network.layer.macroscopic.MacroscopicLinkImpl;
import org.goplanit.utils.graph.GraphEntities;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLink;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkFactory;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.physical.Node;

public class MacroscopicLinkFactoryImpl
extends GraphEntityFactoryImpl<MacroscopicLink>
implements MacroscopicLinkFactory {
    private static final Logger LOGGER = Logger.getLogger(MacroscopicLinkFactoryImpl.class.getCanonicalName());

    protected MacroscopicLinkFactoryImpl(IdGroupingToken groupIdToken) {
        super(groupIdToken);
    }

    @Override
    protected void setGraphEntities(GraphEntities<MacroscopicLink> macroscopicLinks) {
        super.setGraphEntities(macroscopicLinks);
    }

    public MacroscopicLinkFactoryImpl(IdGroupingToken groupIdToken, GraphEntities<MacroscopicLink> macroscopicLinks) {
        super(groupIdToken, macroscopicLinks);
    }

    public MacroscopicLinkImpl<Node, MacroscopicLinkSegment> registerNew(Node nodeA, Node nodeB, double lengthKm, boolean registerOnNodes) {
        if (nodeA == null || nodeB == null) {
            LOGGER.warning("Unable to create new macroscopic link, one or more of its nodes are not defined");
            return null;
        }
        MacroscopicLinkImpl<Node, MacroscopicLinkSegment> newLink = new MacroscopicLinkImpl<Node, MacroscopicLinkSegment>(this.getIdGroupingToken(), nodeA, nodeB);
        this.getGraphEntities().register(newLink);
        newLink.setLengthKm(lengthKm);
        if (registerOnNodes) {
            nodeA.addEdge(newLink);
            nodeB.addEdge(newLink);
        }
        return newLink;
    }
}

