/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.macroscopic;

import java.util.logging.Logger;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.goplanit.network.layer.NetworkLayerGenerator;
import org.goplanit.network.layer.macroscopic.AccessGroupPropertiesFactory;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.AccessGroupProperties;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLink;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.unit.Unit;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;

public class MacroscopicGridNetworkLayerGenerator
implements NetworkLayerGenerator {
    private static final Logger LOGGER = Logger.getLogger(MacroscopicGridNetworkLayerGenerator.class.getCanonicalName());
    private final int rows;
    private final int columns;
    private final MacroscopicNetworkLayers layersContainer;
    private final Mode[] modes;
    public static final String PHYSICAL_LINK_SEGMENT_TYPE_NAME = "default";

    private void createNodes(MacroscopicNetworkLayer networkLayer, GeometryFactory geoFactory) throws PlanItException {
        for (int colIndex = 0; colIndex < this.columns; ++colIndex) {
            for (int rowIndex = 0; rowIndex < this.rows; ++rowIndex) {
                long yMeters = Math.round(Unit.KM.convertTo((Unit)Unit.METER, (double)rowIndex));
                long xMeters = Math.round(Unit.KM.convertTo((Unit)Unit.METER, (double)colIndex));
                Node node = networkLayer.getNodes().getFactory().registerNew();
                node.setPosition(geoFactory.createPoint(new Coordinate((double)xMeters, (double)yMeters)));
                node.setXmlId(String.valueOf(node.getId()));
            }
        }
    }

    private void createLinks(MacroscopicNetworkLayer networkLayer, GeometryFactory geoFactory) throws PlanItException {
        MacroscopicLink newLink;
        Node nodeB;
        Node nodeA;
        long nodeBId;
        long nodeAId;
        int rowIndex;
        int offset = 0;
        int colIndex = 0;
        while (colIndex < this.columns) {
            for (rowIndex = 1; rowIndex < this.rows; ++rowIndex) {
                nodeAId = offset + rowIndex - 1;
                nodeBId = nodeAId + 1L;
                nodeA = (Node)networkLayer.getNodes().get(nodeAId);
                nodeB = (Node)networkLayer.getNodes().get(nodeBId);
                newLink = networkLayer.getLinks().getFactory().registerNew(nodeA, nodeB, 1.0, true);
                if (newLink == null) {
                    LOGGER.severe(String.format("Unable to create link for nodes with internal ids (A:%d, B:%d)", nodeAId, nodeBId));
                    continue;
                }
                newLink.setXmlId(String.valueOf(newLink.getId()));
            }
            ++colIndex;
            offset += this.rows;
        }
        offset = 0;
        colIndex = 0;
        while (colIndex < this.columns - 1) {
            for (rowIndex = 0; rowIndex < this.rows; ++rowIndex) {
                nodeAId = offset + rowIndex;
                nodeBId = nodeAId + (long)this.rows;
                nodeA = (Node)networkLayer.getNodes().get(nodeAId);
                nodeB = (Node)networkLayer.getNodes().get(nodeBId);
                newLink = networkLayer.getLinks().getFactory().registerNew(nodeA, nodeB, 1.0, true);
                if (newLink == null) {
                    LOGGER.severe(String.format("Unable to create link for nodes with internal ids (A:%d, B:%d)", nodeAId, nodeBId));
                    continue;
                }
                newLink.setXmlId(String.valueOf(newLink.getId()));
            }
            ++colIndex;
            offset += this.rows;
        }
    }

    private void createLinkSegments(MacroscopicNetworkLayer networkLayer, GeometryFactory geoFactory) throws PlanItException {
        MacroscopicLinkSegmentType defaultLinkSegmentType = (MacroscopicLinkSegmentType)networkLayer.getLinkSegmentTypes().getFirst();
        boolean registerOnNodes = true;
        for (MacroscopicLink link : networkLayer.getLinks()) {
            MacroscopicLinkSegment linkSegment = networkLayer.getLinkSegments().getFactory().registerNew(link, defaultLinkSegmentType, true, registerOnNodes);
            linkSegment.setXmlId(String.valueOf(linkSegment.getId()));
            linkSegment = networkLayer.getLinkSegments().getFactory().registerNew(link, defaultLinkSegmentType, false, registerOnNodes);
            linkSegment.setXmlId(String.valueOf(linkSegment.getId()));
        }
    }

    private void populateGrid(MacroscopicNetworkLayer networkLayer) throws PlanItException {
        GeometryFactory geoFactory = JTSFactoryFinder.getGeometryFactory();
        this.createNodes(networkLayer, geoFactory);
        this.createLinks(networkLayer, geoFactory);
        this.createLinkSegments(networkLayer, geoFactory);
    }

    protected MacroscopicGridNetworkLayerGenerator(int rows, int columns, MacroscopicNetworkLayers layersContainer, Mode ... modes) {
        this.rows = rows;
        this.columns = columns;
        this.layersContainer = layersContainer;
        this.modes = modes;
    }

    public MacroscopicNetworkLayer generate() {
        MacroscopicNetworkLayer networkLayer = this.layersContainer.getFactory().registerNew(this.modes);
        this.createDefaultLinkSegmentType(networkLayer, PHYSICAL_LINK_SEGMENT_TYPE_NAME);
        try {
            this.populateGrid(networkLayer);
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe("Unable to populate grid for macroscopic network layer");
        }
        return networkLayer;
    }

    private void createDefaultLinkSegmentType(MacroscopicNetworkLayer networkLayer, String linkSegmentTypeName) {
        MacroscopicLinkSegmentType linkSegmentType = networkLayer.getLinkSegmentTypes().getFactory().registerNew(linkSegmentTypeName);
        AccessGroupProperties accessGroupProperties = AccessGroupPropertiesFactory.create(this.modes);
        linkSegmentType.addAccessGroupProperties(accessGroupProperties);
    }

    public static MacroscopicGridNetworkLayerGenerator create(int rows, int columns, MacroscopicNetworkLayers layersContainer, Mode ... modes) {
        return new MacroscopicGridNetworkLayerGenerator(rows, columns, layersContainer, modes);
    }
}

