/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.macroscopic;

import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import org.goplanit.network.layer.UntypedNetworkLayerImpl;
import org.goplanit.network.layer.physical.ConjugateLinkSegmentsImpl;
import org.goplanit.network.layer.physical.ConjugateLinksImpl;
import org.goplanit.network.layer.physical.ConjugateNodesImpl;
import org.goplanit.utils.graph.GraphEntityDeepCopyMapper;
import org.goplanit.utils.graph.directed.ConjugateDirectedVertex;
import org.goplanit.utils.graph.directed.DirectedEdge;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.network.layer.ConjugateMacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.physical.ConjugateLink;
import org.goplanit.utils.network.layer.physical.ConjugateLinkSegment;
import org.goplanit.utils.network.layer.physical.ConjugateLinkSegments;
import org.goplanit.utils.network.layer.physical.ConjugateLinks;
import org.goplanit.utils.network.layer.physical.ConjugateNode;
import org.goplanit.utils.network.layer.physical.ConjugateNodes;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.network.virtual.ConjugateConnectoidNode;
import org.goplanit.utils.network.virtual.ConjugateVirtualNetwork;

public class ConjugateMacroscopicNetworkLayerImpl
extends UntypedNetworkLayerImpl<ConjugateNode, ConjugateLink, ConjugateLinkSegment>
implements ConjugateMacroscopicNetworkLayer {
    private static final Logger LOGGER = Logger.getLogger(ConjugateMacroscopicNetworkLayerImpl.class.getCanonicalName());
    protected final MacroscopicNetworkLayer originalLayer;

    protected void update(ConjugateVirtualNetwork conjugateVirtualNetwork) {
        this.reset();
        HashMap<Object, Object> edgeToConjugateNode = new HashMap<Object, Object>();
        for (Link link : this.originalLayer.getLinks()) {
            ConjugateNode conjugateNode = this.getConjugateNodes().getFactory().registerNew(link);
            edgeToConjugateNode.put(link, conjugateNode);
        }
        if (conjugateVirtualNetwork != null) {
            for (ConjugateConnectoidNode conjugateConnectoidNode : conjugateVirtualNetwork.getConjugateConnectoidNodes()) {
                DirectedEdge originalEdge = conjugateConnectoidNode.getOriginalEdge();
                edgeToConjugateNode.put(originalEdge, conjugateConnectoidNode);
            }
        }
        for (Node node : this.originalLayer.getNodes()) {
            Iterator linkIter = node.getLinks().iterator();
            while (linkIter.hasNext()) {
                Link link = (Link)linkIter.next();
                Iterator nextLinkIter = node.getLinks().iterator();
                while (nextLinkIter.hasNext() && !((Link)nextLinkIter.next()).equals(link)) {
                }
                if (linkIter.hasNext() && !nextLinkIter.hasNext()) {
                    LOGGER.warning("Unable to find next link while updating conjugate macroscopic network, this shouldn't happen, abort");
                    return;
                }
                while (nextLinkIter.hasNext()) {
                    Pair baPair;
                    boolean directionAb;
                    Link nextLink = (Link)nextLinkIter.next();
                    ConjugateDirectedVertex conjugateVertexA = (ConjugateDirectedVertex)edgeToConjugateNode.get(link);
                    ConjugateDirectedVertex conjugateVertexB = (ConjugateDirectedVertex)edgeToConjugateNode.get(nextLink);
                    if ((conjugateVertexA == null || conjugateVertexB == null) && conjugateVirtualNetwork != null) {
                        LOGGER.warning("Unable to obtain conjugate vertex for original link, this shouldn't happen, skip");
                        continue;
                    }
                    ConjugateLink conjugateLink = this.getConjugateLinks().getFactory().registerNew(conjugateVertexA, conjugateVertexB, true, link, nextLink);
                    Pair abPair = conjugateLink.getOriginalAdjacentEdgeSegments(directionAb = true);
                    if (abPair.bothNotNull()) {
                        this.getConjugateLinkSegments().getFactory().registerNew(conjugateLink, directionAb, true);
                    }
                    if (!(baPair = conjugateLink.getOriginalAdjacentEdgeSegments(directionAb = !directionAb)).bothNotNull()) continue;
                    this.getConjugateLinkSegments().getFactory().registerNew(conjugateLink, directionAb, true);
                }
            }
        }
    }

    protected ConjugateMacroscopicNetworkLayerImpl(IdGroupingToken groupId, MacroscopicNetworkLayer originalLayer) {
        this(groupId, new ConjugateNodesImpl(groupId), new ConjugateLinksImpl(groupId), new ConjugateLinkSegmentsImpl(groupId), originalLayer);
    }

    protected ConjugateMacroscopicNetworkLayerImpl(IdGroupingToken groupId, ConjugateNodes conjugateNodes, ConjugateLinks conjugateLinks, ConjugateLinkSegments conjugateLinkSegments, MacroscopicNetworkLayer originalLayer) {
        super(groupId, conjugateNodes, conjugateLinks, conjugateLinkSegments);
        this.originalLayer = originalLayer;
    }

    protected ConjugateMacroscopicNetworkLayerImpl(ConjugateMacroscopicNetworkLayerImpl other, boolean deepCopy, GraphEntityDeepCopyMapper<ConjugateNode> nodeMapper, GraphEntityDeepCopyMapper<ConjugateLink> linkMapper, GraphEntityDeepCopyMapper<ConjugateLinkSegment> linkSegmentMapper) {
        super(other, deepCopy, nodeMapper, linkMapper, linkSegmentMapper);
        this.originalLayer = other.originalLayer;
    }

    @Override
    public void logInfo(String prefix) {
        super.logInfo(prefix);
    }

    public ConjugateLinks getConjugateLinks() {
        return (ConjugateLinks)this.getDirectedGraph().getEdges();
    }

    public ConjugateLinkSegments getConjugateLinkSegments() {
        return (ConjugateLinkSegments)this.getDirectedGraph().getEdgeSegments();
    }

    public ConjugateNodes getConjugateNodes() {
        return (ConjugateNodes)this.getDirectedGraph().getVertices();
    }

    @Override
    public ConjugateMacroscopicNetworkLayerImpl shallowClone() {
        return new ConjugateMacroscopicNetworkLayerImpl(this, false, null, null, null);
    }

    @Override
    public ConjugateMacroscopicNetworkLayerImpl deepClone() {
        return new ConjugateMacroscopicNetworkLayerImpl(this, true, (GraphEntityDeepCopyMapper<ConjugateNode>)new GraphEntityDeepCopyMapper(), (GraphEntityDeepCopyMapper<ConjugateLink>)new GraphEntityDeepCopyMapper(), (GraphEntityDeepCopyMapper<ConjugateLinkSegment>)new GraphEntityDeepCopyMapper());
    }

    @Override
    public void reset() {
        super.reset();
        this.resetChildManagedIdEntities();
    }

    public void resetChildManagedIdEntities() {
        super.resetChildManagedIdEntities();
    }

    public MacroscopicNetworkLayer getOriginalLayer() {
        return this.originalLayer;
    }
}

