/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.macroscopic;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.AccessGroupProperties;

public class AccessGroupPropertiesImpl
implements AccessGroupProperties {
    protected Double maxSpeedKmH;
    protected Double criticalSpeedKmH;
    protected final Set<Mode> supportedModes;

    AccessGroupPropertiesImpl(double maxSpeedKmH, double criticalSpeedKmH, Collection<Mode> accessModes) {
        this.maxSpeedKmH = maxSpeedKmH;
        this.criticalSpeedKmH = criticalSpeedKmH;
        this.supportedModes = new TreeSet<Mode>(accessModes);
    }

    AccessGroupPropertiesImpl(double maxSpeedKmH, double criticalSpeedKmH, Mode ... accessModes) {
        this.maxSpeedKmH = maxSpeedKmH;
        this.criticalSpeedKmH = criticalSpeedKmH;
        this.supportedModes = new TreeSet<Mode>(Arrays.asList(accessModes));
    }

    AccessGroupPropertiesImpl(double maxSpeedKmH, Collection<Mode> accessModes) {
        this.maxSpeedKmH = maxSpeedKmH;
        this.criticalSpeedKmH = null;
        this.supportedModes = new TreeSet<Mode>(accessModes);
    }

    AccessGroupPropertiesImpl(double maxSpeedKmH, Mode ... accessModes) {
        this.maxSpeedKmH = maxSpeedKmH;
        this.criticalSpeedKmH = null;
        this.supportedModes = new TreeSet<Mode>(Arrays.asList(accessModes));
    }

    public AccessGroupPropertiesImpl(Collection<Mode> accessModes) {
        this.criticalSpeedKmH = null;
        this.maxSpeedKmH = null;
        this.supportedModes = new TreeSet<Mode>(accessModes);
    }

    public AccessGroupPropertiesImpl(AccessGroupPropertiesImpl other, boolean deepCopy) {
        this.maxSpeedKmH = other.maxSpeedKmH;
        this.criticalSpeedKmH = other.criticalSpeedKmH;
        this.supportedModes = new TreeSet<Mode>(other.supportedModes);
    }

    public Double getMaximumSpeedKmH() {
        return this.maxSpeedKmH;
    }

    public Double getCriticalSpeedKmH() {
        return this.criticalSpeedKmH;
    }

    public void setMaximumSpeedKmH(Double maxSpeedKmH) {
        this.maxSpeedKmH = maxSpeedKmH;
    }

    public void setCriticalSpeedKmH(Double criticalSpeed) {
        this.criticalSpeedKmH = criticalSpeed;
    }

    public AccessGroupProperties shallowClone() {
        return new AccessGroupPropertiesImpl(this, false);
    }

    public AccessGroupProperties deepClone() {
        return new AccessGroupPropertiesImpl(this, true);
    }

    public Set<Mode> getAccessModes() {
        return Collections.unmodifiableSet(this.supportedModes);
    }

    public boolean removeAccessMode(Mode toBeRemovedMode) {
        return this.supportedModes.remove(toBeRemovedMode);
    }

    public boolean isEqualExceptForModes(AccessGroupProperties accessProperties) {
        boolean maxSpeedEqual = false;
        maxSpeedEqual = this.getMaximumSpeedKmH() == null || accessProperties.getMaximumSpeedKmH() == null ? this.getMaximumSpeedKmH() == null && accessProperties.getMaximumSpeedKmH() == null : Precision.equal((double)this.getMaximumSpeedKmH(), (double)accessProperties.getMaximumSpeedKmH());
        boolean critSpeedEqual = false;
        critSpeedEqual = this.getCriticalSpeedKmH() == null || accessProperties.getCriticalSpeedKmH() == null ? this.getCriticalSpeedKmH() == null && accessProperties.getCriticalSpeedKmH() == null : Precision.equal((double)this.getCriticalSpeedKmH(), (double)accessProperties.getCriticalSpeedKmH());
        return maxSpeedEqual && critSpeedEqual;
    }

    public void addAccessMode(Mode mode) {
        this.supportedModes.add(mode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Modes: [");
        this.supportedModes.forEach(m -> sb.append(m.toString()).append(","));
        sb.deleteCharAt(sb.length() - 1);
        sb.append("] maxSpeed (km/h): ");
        sb.append(this.getMaximumSpeedOrDefaultKmH(-1.0));
        sb.append(" critSpeed (km/h): ");
        sb.append(this.getCriticalSpeedOrDefaultKmH(-1.0));
        return sb.toString();
    }
}

