/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer;

import java.util.logging.Logger;
import org.goplanit.graph.directed.UntypedDirectedGraphImpl;
import org.goplanit.network.layer.TopologicalLayerImpl;
import org.goplanit.network.layer.modifier.UntypedNetworkLayerModifierImpl;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.graph.GraphEntityDeepCopyMapper;
import org.goplanit.utils.graph.ManagedGraphEntities;
import org.goplanit.utils.graph.UntypedDirectedGraph;
import org.goplanit.utils.graph.directed.DirectedEdge;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.ManagedIdEntities;
import org.goplanit.utils.network.layer.NetworkLayer;
import org.goplanit.utils.network.layer.UntypedDirectedGraphLayer;
import org.goplanit.utils.network.layer.modifier.UntypedDirectedGraphLayerModifier;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class UntypedNetworkLayerImpl<V extends DirectedVertex, E extends DirectedEdge, S extends EdgeSegment>
extends TopologicalLayerImpl
implements UntypedDirectedGraphLayer<V, E, S> {
    private static final Logger LOGGER = Logger.getLogger(UntypedNetworkLayerImpl.class.getCanonicalName());
    protected final UntypedDirectedGraphImpl<V, E, S> directedGraph;
    protected UntypedDirectedGraphLayerModifier<V, E, S> layerModifier;

    protected UntypedDirectedGraph<V, E, S> getDirectedGraph() {
        return this.directedGraph;
    }

    public <Vx extends ManagedGraphEntities<V>, Ex extends ManagedGraphEntities<E>, Sx extends ManagedGraphEntities<S>> UntypedNetworkLayerImpl(IdGroupingToken tokenId, Vx vertices, Ex edges, Sx edgeSegments) {
        super(tokenId);
        this.directedGraph = new UntypedDirectedGraphImpl(tokenId, vertices, edges, edgeSegments);
        this.layerModifier = new UntypedNetworkLayerModifierImpl<V, E, S>(this.directedGraph);
    }

    public UntypedNetworkLayerImpl(UntypedNetworkLayerImpl<V, E, S> other, boolean deepCopy, GraphEntityDeepCopyMapper<V> vertexMapper, GraphEntityDeepCopyMapper<E> edgeMapper, GraphEntityDeepCopyMapper<S> edgeSegmentMapper) {
        super(other, deepCopy);
        this.directedGraph = deepCopy ? other.directedGraph.smartDeepClone(vertexMapper, edgeMapper, edgeSegmentMapper) : other.directedGraph.shallowClone();
        this.layerModifier = new UntypedNetworkLayerModifierImpl<V, E, S>(this.directedGraph);
    }

    public IdGroupingToken getLayerIdGroupingToken() {
        return this.directedGraph.getGraphIdGroupingToken();
    }

    public void transform(CoordinateReferenceSystem fromCoordinateReferenceSystem, CoordinateReferenceSystem toCoordinateReferenceSystem) throws PlanItException {
        try {
            this.getDirectedGraph().transformGeometries(PlanitJtsUtils.findMathTransform((CoordinateReferenceSystem)fromCoordinateReferenceSystem, (CoordinateReferenceSystem)toCoordinateReferenceSystem));
        }
        catch (Exception e) {
            PlanitJtsUtils.findMathTransform((CoordinateReferenceSystem)fromCoordinateReferenceSystem, (CoordinateReferenceSystem)toCoordinateReferenceSystem);
            throw new PlanItException(String.format("%s error during transformation of physical network %s CRS", NetworkLayer.createLayerLogPrefix((NetworkLayer)this), this.getXmlId()), (Throwable)e);
        }
    }

    public Envelope createBoundingBox() {
        if (this.getDirectedGraph().getVertices().isEmpty()) {
            return null;
        }
        Envelope envelope = new Envelope(((DirectedVertex)this.getDirectedGraph().getVertices().iterator().next()).getPosition().getCoordinate());
        this.getDirectedGraph().getVertices().forEach(v -> envelope.expandToInclude(v.getPosition().getCoordinate()));
        return envelope;
    }

    public boolean isEmpty() {
        return this.directedGraph.isEmpty();
    }

    public boolean validate() {
        return this.directedGraph.validate();
    }

    public UntypedDirectedGraphLayerModifier<V, E, S> getLayerModifier() {
        return this.layerModifier;
    }

    @Override
    public abstract UntypedNetworkLayerImpl<V, E, S> shallowClone();

    @Override
    public abstract UntypedNetworkLayerImpl<V, E, S> deepClone();

    @Override
    public void reset() {
        super.reset();
        ((ManagedIdEntities)this.directedGraph.getVertices()).reset();
        ((ManagedIdEntities)this.directedGraph.getEdges()).reset();
        ((ManagedIdEntities)this.directedGraph.getEdgeSegments()).reset();
    }
}

