/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.PredefinedMode;
import org.goplanit.utils.mode.PredefinedModeType;
import org.goplanit.utils.network.layer.NetworkLayer;

public abstract class NetworkLayerImpl
extends ExternalIdAbleImpl
implements NetworkLayer {
    private static final Logger LOGGER = Logger.getLogger(NetworkLayerImpl.class.getCanonicalName());
    protected final Map<Long, Mode> supportedModes;

    protected static long generateId(IdGroupingToken tokenId) {
        return IdGenerator.generateId((IdGroupingToken)tokenId, (Class)NetworkLayer.NETWORK_LAYER_ID_CLASS);
    }

    protected NetworkLayerImpl(IdGroupingToken tokenId) {
        super(NetworkLayerImpl.generateId(tokenId));
        this.supportedModes = new TreeMap<Long, Mode>();
    }

    protected NetworkLayerImpl(NetworkLayerImpl other, boolean deepCopy) {
        super((ExternalIdAbleImpl)other);
        this.supportedModes = new TreeMap<Long, Mode>(other.supportedModes);
    }

    public boolean registerSupportedMode(Mode supportedMode) {
        if (supportedMode != null) {
            this.supportedModes.put(supportedMode.getId(), supportedMode);
            return true;
        }
        return false;
    }

    public boolean registerSupportedModes(Collection<Mode> supportedModes) {
        boolean success = false;
        if (supportedModes != null && supportedModes.size() > 0) {
            success = true;
            for (Mode mode : supportedModes) {
                if (this.registerSupportedMode(mode)) continue;
                success = false;
            }
        }
        return success;
    }

    public Collection<Mode> getSupportedModes() {
        return this.supportedModes.values();
    }

    public boolean supportsPredefinedMode(PredefinedModeType predefinedModeType) {
        return this.supportedModes.values().stream().filter(m -> m.isPredefinedModeType() && ((PredefinedMode)m).getPredefinedModeType() == predefinedModeType).findFirst().isPresent();
    }

    public void logInfo(String prefix) {
        LOGGER.info(String.format("%ssupported modes: %s", prefix, this.getSupportedModes().stream().map(mode -> mode.getXmlId()).collect(Collectors.joining(", "))));
    }

    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = NetworkLayerImpl.generateId(tokenId);
        this.setId(newId);
        return newId;
    }

    public void reset() {
        this.supportedModes.clear();
    }

    public abstract NetworkLayerImpl shallowClone();

    public abstract NetworkLayerImpl deepClone();
}

