/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network;

import org.goplanit.network.TopologicalLayerNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.ManagedIdDeepCopyMapper;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.physical.UntypedPhysicalLayer;
import org.goplanit.utils.network.layers.UntypedPhysicalNetworkLayers;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class UntypedPhysicalNetwork<L extends UntypedPhysicalLayer<?, ?, ?>, LS extends UntypedPhysicalNetworkLayers<L>>
extends TopologicalLayerNetwork<L, LS> {
    private static final long serialVersionUID = 3909555719315844733L;

    public UntypedPhysicalNetwork(IdGroupingToken tokenId) {
        super(tokenId);
    }

    public UntypedPhysicalNetwork(IdGroupingToken tokenId, CoordinateReferenceSystem coordinateReferenceSystem) {
        super(tokenId, coordinateReferenceSystem);
    }

    protected UntypedPhysicalNetwork(UntypedPhysicalNetwork<L, LS> other, boolean deepCopy, ManagedIdDeepCopyMapper<Mode> modeMapper, ManagedIdDeepCopyMapper<L> layerMapper) {
        super(other, deepCopy, modeMapper, layerMapper);
    }

    public void removeDanglingSubnetworks() throws PlanItException {
        this.removeDanglingSubnetworks(Integer.MAX_VALUE, Integer.MAX_VALUE, true);
    }

    public void removeDanglingSubnetworks(Integer belowSize, Integer aboveSize, boolean alwaysKeepLargest) {
        for (UntypedPhysicalLayer infrastructureLayer : (UntypedPhysicalNetworkLayers)this.getTransportLayers()) {
            infrastructureLayer.getLayerModifier().removeDanglingSubnetworks(belowSize, aboveSize, alwaysKeepLargest);
        }
    }

    @Override
    public abstract UntypedPhysicalNetwork shallowClone();

    @Override
    public abstract UntypedPhysicalNetwork deepClone();
}

