/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network;

import java.util.logging.Logger;
import org.goplanit.network.LayeredNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.ManagedIdDeepCopyMapper;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.TopologicalLayer;
import org.goplanit.utils.network.layers.TopologicalLayers;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class TopologicalLayerNetwork<T extends TopologicalLayer, U extends TopologicalLayers<T>>
extends LayeredNetwork<T, U> {
    private static final long serialVersionUID = 2402806336978560448L;
    private static final Logger LOGGER = Logger.getLogger(TopologicalLayerNetwork.class.getCanonicalName());
    private CoordinateReferenceSystem coordinateReferenceSystem;

    public TopologicalLayerNetwork(IdGroupingToken tokenId) {
        this(tokenId, (CoordinateReferenceSystem)PlanitJtsCrsUtils.DEFAULT_GEOGRAPHIC_CRS);
    }

    public TopologicalLayerNetwork(IdGroupingToken tokenId, CoordinateReferenceSystem coordinateReferenceSystem) {
        super(tokenId);
        this.coordinateReferenceSystem = coordinateReferenceSystem;
    }

    protected TopologicalLayerNetwork(TopologicalLayerNetwork<T, U> other, boolean deepCopy, ManagedIdDeepCopyMapper<Mode> modeMapper, ManagedIdDeepCopyMapper<T> layerMapper) {
        super(other, deepCopy, modeMapper, layerMapper);
        this.coordinateReferenceSystem = other.getCoordinateReferenceSystem();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.coordinateReferenceSystem;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (((TopologicalLayers)this.getTransportLayers()).isEachLayerEmpty()) {
            this.coordinateReferenceSystem = coordinateReferenceSystem;
        } else {
            LOGGER.warning("Coordinate Reference System is already set. To change the CRS after instantiation, use transform() method");
        }
    }

    public void transform(CoordinateReferenceSystem newCoordinateReferenceSystem) throws PlanItException {
        for (TopologicalLayer layer : (TopologicalLayers)this.getTransportLayers()) {
            layer.transform(this.coordinateReferenceSystem, newCoordinateReferenceSystem);
        }
    }

    public Envelope createBoundingBox() {
        Envelope envelope = null;
        for (TopologicalLayer layer : (TopologicalLayers)this.getTransportLayers()) {
            Envelope layerBoundingBox = layer.createBoundingBox();
            if (envelope == null) {
                envelope = layerBoundingBox;
                continue;
            }
            envelope.expandToInclude(layerBoundingBox);
        }
        return envelope;
    }

    @Override
    public abstract TopologicalLayerNetwork shallowClone();

    @Override
    public abstract TopologicalLayerNetwork deepClone();
}

