/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network;

import java.util.logging.Logger;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.TopologicalLayerNetwork;
import org.goplanit.network.layers.ServiceNetworkLayersImpl;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.ManagedIdDeepCopyMapper;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.ServiceNetworkLayer;
import org.goplanit.utils.network.layers.ServiceNetworkLayers;

public class ServiceNetwork
extends TopologicalLayerNetwork<ServiceNetworkLayer, ServiceNetworkLayers> {
    private static final long serialVersionUID = 632938213490189010L;
    private static final Logger LOGGER = Logger.getLogger(ServiceNetwork.class.getCanonicalName());
    private final MacroscopicNetwork parentNetwork;

    @Override
    protected ServiceNetworkLayers createLayersContainer(IdGroupingToken networkIdToken) {
        return new ServiceNetworkLayersImpl(networkIdToken, this.parentNetwork);
    }

    public ServiceNetwork(IdGroupingToken tokenId, MacroscopicNetwork parentNetwork) {
        super(tokenId);
        this.parentNetwork = parentNetwork;
    }

    public ServiceNetwork(ServiceNetwork other, boolean deepCopy, ManagedIdDeepCopyMapper<ServiceNetworkLayer> layerMapper) {
        super(other, deepCopy, (ManagedIdDeepCopyMapper<Mode>)null, layerMapper);
        this.parentNetwork = other.parentNetwork;
    }

    public MacroscopicNetwork getParentNetwork() {
        return this.parentNetwork;
    }

    @Override
    public void logInfo(String prefix) {
        LOGGER.info(String.format("[STATS] %s Service network %s (external id: %s) has %d layers", prefix, this.getXmlId(), this.getExternalId(), ((ServiceNetworkLayers)this.getTransportLayers()).size()));
        ((ServiceNetworkLayers)this.getTransportLayers()).forEach(layer -> layer.logInfo(prefix.concat(LoggingUtils.serviceNetworkLayerPrefix((long)layer.getId()))));
    }

    @Override
    public ServiceNetwork shallowClone() {
        return new ServiceNetwork(this, false, null);
    }

    @Override
    public ServiceNetwork deepClone() {
        return new ServiceNetwork(this, true, (ManagedIdDeepCopyMapper<ServiceNetworkLayer>)new ManagedIdDeepCopyMapper());
    }
}

