/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.Modes;
import org.goplanit.utils.mode.PredefinedMode;

public class MacroscopicNetworkLayerConfigurator {
    private static final Logger LOGGER = Logger.getLogger(MacroscopicNetworkLayerConfigurator.class.getCanonicalName());
    protected final Set<String> transportLayersByXmlId = new HashSet<String>();
    protected final Map<Mode, String> modeToLayerXmlId = new TreeMap<Mode, String>();
    public static final String ON_STREET_LAYER_XML_ID = "on-street";
    public static final String ACTIVE_LAYER_XML_ID = "active";
    public static final String RAIL_LAYER_ID = "rail";
    public static final String ALL_IN_ONE_LAYER_ID = "all";

    public static MacroscopicNetworkLayerConfigurator createAllInOneConfiguration(Modes modes) {
        MacroscopicNetworkLayerConfigurator allInOne = new MacroscopicNetworkLayerConfigurator();
        allInOne.addLayer(ALL_IN_ONE_LAYER_ID);
        modes.forEach(mode -> allInOne.setModeToLayer((Mode)mode, ALL_IN_ONE_LAYER_ID));
        return allInOne;
    }

    public static MacroscopicNetworkLayerConfigurator createMultiLayerConfiguration(Collection<PredefinedMode> predefinedModes) {
        MacroscopicNetworkLayerConfigurator multiLayerConfiguration = new MacroscopicNetworkLayerConfigurator();
        multiLayerConfiguration.addLayer(ON_STREET_LAYER_XML_ID);
        multiLayerConfiguration.addLayer(RAIL_LAYER_ID);
        multiLayerConfiguration.addLayer(ACTIVE_LAYER_XML_ID);
        block17: for (PredefinedMode mode : predefinedModes) {
            switch (mode.getPredefinedModeType()) {
                case BICYCLE: {
                    multiLayerConfiguration.setModeToLayer((Mode)mode, ACTIVE_LAYER_XML_ID);
                    continue block17;
                }
                case PEDESTRIAN: {
                    multiLayerConfiguration.setModeToLayer((Mode)mode, ACTIVE_LAYER_XML_ID);
                    continue block17;
                }
                case BUS: {
                    multiLayerConfiguration.setModeToLayer((Mode)mode, ON_STREET_LAYER_XML_ID);
                    continue block17;
                }
                case CAR: {
                    multiLayerConfiguration.setModeToLayer((Mode)mode, ON_STREET_LAYER_XML_ID);
                    continue block17;
                }
                case CAR_HIGH_OCCUPANCY: {
                    multiLayerConfiguration.setModeToLayer((Mode)mode, ON_STREET_LAYER_XML_ID);
                    continue block17;
                }
                case CAR_SHARE: {
                    multiLayerConfiguration.setModeToLayer((Mode)mode, ON_STREET_LAYER_XML_ID);
                    continue block17;
                }
                case GOODS_VEHICLE: {
                    multiLayerConfiguration.setModeToLayer((Mode)mode, ON_STREET_LAYER_XML_ID);
                    continue block17;
                }
                case HEAVY_GOODS_VEHICLE: {
                    multiLayerConfiguration.setModeToLayer((Mode)mode, ON_STREET_LAYER_XML_ID);
                    continue block17;
                }
                case LARGE_HEAVY_GOODS_VEHICLE: {
                    multiLayerConfiguration.setModeToLayer((Mode)mode, ON_STREET_LAYER_XML_ID);
                    continue block17;
                }
                case LIGHTRAIL: {
                    multiLayerConfiguration.setModeToLayer((Mode)mode, ON_STREET_LAYER_XML_ID);
                    continue block17;
                }
                case MOTOR_BIKE: {
                    multiLayerConfiguration.setModeToLayer((Mode)mode, ON_STREET_LAYER_XML_ID);
                    continue block17;
                }
                case TRAM: {
                    multiLayerConfiguration.setModeToLayer((Mode)mode, ON_STREET_LAYER_XML_ID);
                    continue block17;
                }
                case SUBWAY: {
                    multiLayerConfiguration.setModeToLayer((Mode)mode, RAIL_LAYER_ID);
                    continue block17;
                }
                case TRAIN: {
                    multiLayerConfiguration.setModeToLayer((Mode)mode, RAIL_LAYER_ID);
                    continue block17;
                }
                case CUSTOM: {
                    LOGGER.warning("custom predefined mode type indicates the mode is in fact not predefined, ignored");
                }
            }
            LOGGER.warning(String.format("invalid predefined mode type %s encountered, ignored", mode.getPredefinedModeType().value()));
        }
        return multiLayerConfiguration;
    }

    public boolean addLayer(String layerXmlId) {
        return this.transportLayersByXmlId.add(layerXmlId);
    }

    public boolean removeLayer(String layerXmlId) throws PlanItException {
        if (layerXmlId == null) {
            return false;
        }
        Iterator<Mode> modeIter = this.modeToLayerXmlId.keySet().iterator();
        while (modeIter.hasNext()) {
            if (!layerXmlId.equals(this.modeToLayerXmlId.get(modeIter.next()))) continue;
            modeIter.remove();
        }
        return this.transportLayersByXmlId.remove(layerXmlId);
    }

    public String setModeToLayer(Mode mode, String layerXmlId) {
        if (!this.transportLayersByXmlId.contains(layerXmlId)) {
            LOGGER.warning(String.format("layer %s not registered, can only register a mode for a layer that has been registered", layerXmlId));
        }
        return this.modeToLayerXmlId.put(mode, layerXmlId);
    }

    public boolean isModeMappedToLayer(Mode mode, String layerXmlId) {
        return this.modeToLayerXmlId.get(mode).equals(layerXmlId);
    }

    public String removeMode(Mode mode) {
        return this.modeToLayerXmlId.remove(mode);
    }
}

