/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network;

import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.collections4.map.HashedMap;
import org.goplanit.network.MacroscopicNetworkLayerConfigurator;
import org.goplanit.network.UntypedPhysicalNetwork;
import org.goplanit.network.layer.macroscopic.MacroscopicGridNetworkLayerGenerator;
import org.goplanit.network.layers.MacroscopicNetworkLayersImpl;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.ManagedIdDeepCopyMapper;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.PredefinedMode;
import org.goplanit.utils.mode.PredefinedModeType;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.NetworkLayer;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;

public class MacroscopicNetwork
extends UntypedPhysicalNetwork<MacroscopicNetworkLayer, MacroscopicNetworkLayers> {
    private static final Logger LOGGER = Logger.getLogger(MacroscopicNetwork.class.getCanonicalName());
    private static final long serialVersionUID = -4208133694967189790L;

    @Override
    protected MacroscopicNetworkLayersImpl createLayersContainer(IdGroupingToken networkIdToken) {
        return new MacroscopicNetworkLayersImpl(networkIdToken);
    }

    public MacroscopicNetwork(IdGroupingToken tokenId) {
        super(tokenId);
    }

    protected MacroscopicNetwork(MacroscopicNetwork other, boolean deepCopy, ManagedIdDeepCopyMapper<Mode> modeMapper, ManagedIdDeepCopyMapper<MacroscopicNetworkLayer> layerMapper) {
        super(other, deepCopy, modeMapper, layerMapper);
    }

    @Override
    public void logInfo(String prefix) {
        LOGGER.info(String.format("%s XML id %s (external id: %s) has %d layers", prefix, this.getXmlId(), this.getExternalId(), ((MacroscopicNetworkLayers)this.getTransportLayers()).size()));
        for (NetworkLayer networkLayer : (MacroscopicNetworkLayers)this.getTransportLayers()) {
            networkLayer.logInfo(LoggingUtils.networkLayerPrefix((long)networkLayer.getId()));
        }
    }

    public void createAndRegisterLayers(MacroscopicNetworkLayerConfigurator layerConfiguration) {
        if (!((MacroscopicNetworkLayers)this.getTransportLayers()).isEmpty()) {
            LOGGER.warning("unable to initialise layers based on provided configuration, since network already has layers defined");
            return;
        }
        HashedMap xmlIdToId = new HashedMap();
        for (String layerXmlId : layerConfiguration.transportLayersByXmlId) {
            MacroscopicNetworkLayer newLayer = ((MacroscopicNetworkLayers)this.getTransportLayers()).getFactory().registerNew();
            newLayer.setXmlId(layerXmlId);
            xmlIdToId.put(layerXmlId, newLayer.getId());
        }
        layerConfiguration.modeToLayerXmlId.forEach((arg_0, arg_1) -> this.lambda$createAndRegisterLayers$0((Map)xmlIdToId, arg_0, arg_1));
    }

    public static MacroscopicNetwork createSimpleGrid(IdGroupingToken tokenId, int rows, int columns) {
        MacroscopicNetwork network = new MacroscopicNetwork(tokenId);
        PredefinedMode carMode = network.getModes().getFactory().registerNew(PredefinedModeType.CAR);
        MacroscopicGridNetworkLayerGenerator.create(rows, columns, (MacroscopicNetworkLayers)network.getTransportLayers(), new Mode[]{carMode}).generate();
        return network;
    }

    @Override
    public MacroscopicNetwork shallowClone() {
        return new MacroscopicNetwork(this, false, null, null);
    }

    @Override
    public MacroscopicNetwork deepClone() {
        return new MacroscopicNetwork(this, true, (ManagedIdDeepCopyMapper<Mode>)new ManagedIdDeepCopyMapper(), (ManagedIdDeepCopyMapper<MacroscopicNetworkLayer>)new ManagedIdDeepCopyMapper());
    }

    private /* synthetic */ void lambda$createAndRegisterLayers$0(Map xmlIdToId, Mode mode, String layerXmlId) {
        ((MacroscopicNetworkLayer)((MacroscopicNetworkLayers)this.getTransportLayers()).get((Object)((Long)xmlIdToId.get(layerXmlId)))).registerSupportedMode(mode);
    }
}

