/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network;

import java.util.logging.Logger;
import org.goplanit.mode.ModesImpl;
import org.goplanit.network.Network;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.ManagedIdDeepCopyMapper;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.Modes;
import org.goplanit.utils.mode.PredefinedModeType;
import org.goplanit.utils.network.layer.NetworkLayer;
import org.goplanit.utils.network.layers.NetworkLayers;

public abstract class LayeredNetwork<U extends NetworkLayer, T extends NetworkLayers<U>>
extends Network {
    private static final long serialVersionUID = 2402806336978560448L;
    private static final Logger LOGGER = Logger.getLogger(LayeredNetwork.class.getCanonicalName());
    private final Modes modes;
    private T transportLayers;

    protected abstract T createLayersContainer(IdGroupingToken var1);

    public LayeredNetwork(IdGroupingToken tokenId) {
        super(tokenId);
        this.modes = new ModesImpl(tokenId);
        this.transportLayers = null;
    }

    protected LayeredNetwork(LayeredNetwork<U, T> other, boolean deepCopy, ManagedIdDeepCopyMapper<Mode> modeMapper, ManagedIdDeepCopyMapper<U> layerMapper) {
        super(other, deepCopy);
        if (deepCopy) {
            this.modes = other.modes.deepCloneWithMapping(modeMapper);
            this.transportLayers = other.getTransportLayers().deepCloneWithMapping(layerMapper);
        } else {
            this.modes = other.modes.shallowClone();
            this.transportLayers = other.getTransportLayers().shallowClone();
        }
        this.transportLayers = deepCopy ? other.getTransportLayers().deepClone() : other.getTransportLayers().shallowClone();
    }

    public U getLayerByMode(Mode mode) {
        return (U)this.transportLayers.get(mode);
    }

    public U getLayerByPredefinedModeType(PredefinedModeType predefinedModeType) {
        return (U)this.transportLayers.get(predefinedModeType);
    }

    public Modes getModes() {
        return this.modes;
    }

    public T getTransportLayers() {
        if (this.transportLayers == null) {
            this.transportLayers = this.createLayersContainer(this.getNetworkGroupingTokenId());
        }
        return this.transportLayers;
    }

    @Override
    public void reset() {
        super.reset();
        this.modes.reset();
        this.transportLayers.reset();
    }

    @Override
    public boolean isEmpty() {
        return this.getTransportLayers().isEachLayerEmpty();
    }

    @Override
    public abstract LayeredNetwork shallowClone();

    @Override
    public abstract LayeredNetwork deepClone();
}

