/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.mode;

import org.goplanit.mode.PhysicalModeFeaturesImpl;
import org.goplanit.mode.UsabilityModeFeaturesImpl;
import org.goplanit.utils.id.ExternalIdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.PhysicalModeFeatures;
import org.goplanit.utils.mode.UsabilityModeFeatures;

public class ModeImpl
extends ExternalIdAbleImpl
implements Mode {
    public static final Long DEFAULT_EXTERNAL_ID = 1L;
    private final double maxSpeed;
    private final double pcu;
    private final String name;
    private PhysicalModeFeaturesImpl physicalFeatures;
    private UsabilityModeFeaturesImpl usedToFeatures;

    protected static long generateId(IdGroupingToken tokenId) {
        return IdGenerator.generateId((IdGroupingToken)tokenId, (Class)Mode.MODE_ID_CLASS);
    }

    protected ModeImpl(IdGroupingToken groupId, double maxSpeed, String name, double pcu) {
        this(groupId, name, maxSpeed, pcu, new PhysicalModeFeaturesImpl(), new UsabilityModeFeaturesImpl());
    }

    protected ModeImpl(IdGroupingToken tokenId, String name, double maxSpeed, double pcu, PhysicalModeFeaturesImpl physicalFeatures, UsabilityModeFeaturesImpl usabilityFeatures) {
        super(ModeImpl.generateId(tokenId));
        this.name = name;
        this.maxSpeed = maxSpeed;
        this.pcu = pcu;
        this.physicalFeatures = physicalFeatures;
        this.usedToFeatures = usabilityFeatures;
    }

    protected ModeImpl(ModeImpl other, boolean deepCopy) {
        super((ExternalIdAbleImpl)other);
        this.name = other.name;
        this.maxSpeed = other.maxSpeed;
        this.pcu = other.pcu;
        this.physicalFeatures = deepCopy ? new PhysicalModeFeaturesImpl(other.physicalFeatures) : other.physicalFeatures;
        this.usedToFeatures = deepCopy ? new UsabilityModeFeaturesImpl(other.usedToFeatures) : other.usedToFeatures;
    }

    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = ModeImpl.generateId(tokenId);
        this.setId(newId);
        return newId;
    }

    public String getName() {
        return this.name;
    }

    public double getMaximumSpeedKmH() {
        return this.maxSpeed;
    }

    public double getPcu() {
        return this.pcu;
    }

    public final PhysicalModeFeatures getPhysicalFeatures() {
        return this.physicalFeatures;
    }

    public final UsabilityModeFeatures getUseFeatures() {
        return this.usedToFeatures;
    }

    public ModeImpl shallowClone() {
        return new ModeImpl(this, false);
    }

    public ModeImpl deepClone() {
        return new ModeImpl(this, true);
    }
}

