/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.logging;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.goplanit.utils.resource.ResourceUtils;

public class Logging {
    private static final String DEFAULT_LOGGING_PROPERTIES_FILE_NAME = "logging.properties";
    private static final String LEVEL_PROPERTY = "java.util.logging.FileHandler.level";
    private static final Level DEFAULT_LEVEL = Level.INFO;

    public static void closeLogger(Logger logger) {
        Handler[] handlers;
        for (Handler handler : handlers = logger.getHandlers()) {
            handler.close();
        }
    }

    public static Logger createLogger(Class<?> clazz) throws Exception {
        Optional<Logger> logger = Logging.createLogger(clazz, null);
        if (logger.isEmpty()) {
            System.out.println(String.format("Unable to create logger for class %s", clazz.getName()));
            return null;
        }
        return logger.get();
    }

    public static Optional<Logger> createLogger(Class<?> clazz, String loggingFileName) throws Exception {
        Logger logger = Logger.getLogger("");
        if (loggingFileName != null) {
            FileHandler handler = new FileHandler(loggingFileName);
            SimpleFormatter formatter = new SimpleFormatter();
            handler.setFormatter(formatter);
            Properties p = new Properties();
            URL url = ClassLoader.getSystemResource(DEFAULT_LOGGING_PROPERTIES_FILE_NAME);
            if (url != null) {
                p.load(url.openStream());
            }
            Level level = null;
            level = p.containsKey(LEVEL_PROPERTY) ? Level.parse(p.getProperty(LEVEL_PROPERTY)) : DEFAULT_LEVEL;
            handler.setLevel(level);
            logger.addHandler(handler);
        } else {
            LogManager logManager = LogManager.getLogManager();
            URI resourceUri = ResourceUtils.getResourceUri((String)DEFAULT_LOGGING_PROPERTIES_FILE_NAME);
            if (resourceUri == null) {
                return Optional.empty();
            }
            InputStream inputStream = ResourceUtils.getResourceAsInputStream((URI)resourceUri);
            logManager.readConfiguration(inputStream);
            logManager.addLogger(logger);
        }
        return Optional.of(logger);
    }
}

