/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.graph.modifier.event.handler;

import java.util.logging.Logger;
import org.goplanit.graph.modifier.event.BreakEdgeEvent;
import org.goplanit.utils.event.EventType;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.modifier.event.GraphModificationEvent;
import org.goplanit.utils.graph.modifier.event.GraphModifierListener;

public class SyncXmlIdToIdBreakEdgeHandler
implements GraphModifierListener {
    private static final Logger LOGGER = Logger.getLogger(SyncXmlIdToIdBreakEdgeHandler.class.getCanonicalName());

    protected void onBreakEdge(Edge aToBreak, Edge breakToB) {
        aToBreak.setXmlId(String.valueOf(aToBreak.getId()));
        breakToB.setXmlId(String.valueOf(breakToB.getId()));
    }

    public EventType[] getKnownSupportedEventTypes() {
        return new EventType[]{BreakEdgeEvent.EVENT_TYPE};
    }

    public void onGraphModificationEvent(GraphModificationEvent event) {
        if (!event.getType().equals((Object)BreakEdgeEvent.EVENT_TYPE)) {
            LOGGER.warning(String.format("%s only supports break edge events", SyncXmlIdToIdBreakEdgeHandler.class.getName()));
            return;
        }
        BreakEdgeEvent breakEdgeEvent = (BreakEdgeEvent)((Object)BreakEdgeEvent.class.cast(event));
        this.onBreakEdge(breakEdgeEvent.getEdgeFromVertexAToBreak(), breakEdgeEvent.getEdgeFromBreakToVertexB());
    }
}

