/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.graph.modifier;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Logger;
import org.goplanit.graph.modifier.event.BreakEdgeEvent;
import org.goplanit.graph.modifier.event.RecreatedGraphEntitiesManagedIdsEvent;
import org.goplanit.graph.modifier.event.RemoveSubGraphEdgeEvent;
import org.goplanit.graph.modifier.event.RemoveSubGraphEvent;
import org.goplanit.graph.modifier.event.RemoveSubGraphVertexEvent;
import org.goplanit.utils.event.Event;
import org.goplanit.utils.event.EventListener;
import org.goplanit.utils.event.EventProducerImpl;
import org.goplanit.utils.event.EventType;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.UntypedGraph;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.graph.modifier.GraphModifier;
import org.goplanit.utils.graph.modifier.event.GraphModificationEvent;
import org.goplanit.utils.graph.modifier.event.GraphModifierEventType;
import org.goplanit.utils.graph.modifier.event.GraphModifierListener;
import org.goplanit.utils.id.ManagedId;
import org.goplanit.utils.id.ManagedIdEntities;
import org.goplanit.utils.misc.Pair;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GraphModifierImpl
extends EventProducerImpl
implements GraphModifier<Vertex, Edge> {
    private static final Logger LOGGER = Logger.getLogger(GraphModifierImpl.class.getCanonicalName());
    protected final UntypedGraph<?, ?> theGraph;

    protected static void updateBrokenEdgeGeometry(Edge brokenEdge, Vertex vertexBrokenAt) {
        LineString updatedGeometry = null;
        if (brokenEdge.getVertexA().equals(vertexBrokenAt)) {
            updatedGeometry = PlanitJtsUtils.createCopyWithoutCoordinatesBefore((Point)vertexBrokenAt.getPosition(), (LineString)brokenEdge.getGeometry());
        } else if (brokenEdge.getVertexB().equals(vertexBrokenAt)) {
            updatedGeometry = PlanitJtsUtils.createCopyWithoutCoordinatesAfter((Point)vertexBrokenAt.getPosition(), (LineString)brokenEdge.getGeometry());
        } else {
            LOGGER.warning(String.format("unable to locate vertex to break at (%s) for broken edge %s (id:%d)", vertexBrokenAt.getPosition().toString(), brokenEdge.getExternalId(), brokenEdge.getId()));
        }
        brokenEdge.setGeometry(updatedGeometry);
    }

    protected Set<Vertex> processSubNetworkVertex(Vertex referenceVertex) {
        PlanItRunTimeException.throwIfNull((Object)referenceVertex, (String)"provided reference vertex is null when identifying its subnetwork, thisis not allowed");
        HashSet<Vertex> subNetworkVertices = new HashSet<Vertex>();
        subNetworkVertices.add(referenceVertex);
        HashSet<Vertex> verticesToExplore = new HashSet<Vertex>();
        verticesToExplore.add(referenceVertex);
        Iterator vertexIter = verticesToExplore.iterator();
        while (vertexIter.hasNext()) {
            Vertex currVertex = (Vertex)vertexIter.next();
            vertexIter.remove();
            Collection edgesOfCurrVertex = currVertex.getEdges();
            for (Edge currEdge : edgesOfCurrVertex) {
                if (currEdge.getVertexA() != null && currEdge.getVertexA().getId() != currVertex.getId() && !subNetworkVertices.contains(currEdge.getVertexA())) {
                    subNetworkVertices.add(currEdge.getVertexA());
                    verticesToExplore.add(currEdge.getVertexA());
                    continue;
                }
                if (currEdge.getVertexB() == null || currEdge.getVertexB().getId() == currVertex.getId() || subNetworkVertices.contains(currEdge.getVertexB())) continue;
                subNetworkVertices.add(currEdge.getVertexB());
                verticesToExplore.add(currEdge.getVertexB());
            }
            vertexIter = verticesToExplore.iterator();
        }
        return subNetworkVertices;
    }

    public GraphModifierImpl(UntypedGraph<?, ?> theGraph) {
        this.theGraph = theGraph;
    }

    public UntypedGraph<?, ?> getGraph() {
        return this.theGraph;
    }

    public void fireEvent(EventListener eventListener, Event event) {
        ((GraphModifierListener)GraphModifierListener.class.cast(eventListener)).onGraphModificationEvent((GraphModificationEvent)GraphModificationEvent.class.cast(event));
    }

    public void removeVertex(Vertex vertex) {
        for (Edge edge : vertex.getEdges()) {
            edge.removeVertex(vertex);
        }
        vertex.removeAllEdges();
        this.theGraph.getVertices().remove(vertex.getId());
        if (this.hasListener((EventType)RemoveSubGraphVertexEvent.EVENT_TYPE)) {
            this.fireEvent((Event)new RemoveSubGraphVertexEvent(this, vertex));
        }
    }

    public void removeEdge(Edge edge) {
        if (edge.getVertexA() != null) {
            edge.getVertexA().removeEdge(edge);
        }
        if (edge.getVertexB() != null) {
            edge.getVertexB().removeEdge(edge);
        }
        this.theGraph.getEdges().remove(edge.getId());
        if (this.hasListener((EventType)RemoveSubGraphEdgeEvent.EVENT_TYPE)) {
            this.fireEvent((Event)new RemoveSubGraphEdgeEvent(this, edge));
        }
    }

    public void removeDanglingSubGraphs(Integer belowSize, Integer aboveSize, boolean alwaysKeepLargest) {
        HashMap<Integer, LongAdder> removedDanglingNetworksBySize = new HashMap<Integer, LongAdder>();
        HashSet remainingVertices = new HashSet(this.theGraph.getVertices().size());
        this.theGraph.getVertices().forEach(vertex -> remainingVertices.add(vertex));
        HashMap<Vertex, Integer> identifiedSubNetworkSizes = new HashMap<Vertex, Integer>();
        while (remainingVertices.iterator().hasNext()) {
            Vertex referenceVertex = (Vertex)remainingVertices.iterator().next();
            Set<Vertex> subNetworkVerticesToPopulate = this.processSubNetworkVertex(referenceVertex);
            identifiedSubNetworkSizes.put(referenceVertex, subNetworkVerticesToPopulate.size());
            remainingVertices.removeAll(subNetworkVerticesToPopulate);
        }
        if (!identifiedSubNetworkSizes.isEmpty()) {
            int maxSubNetworkSize = (Integer)Collections.max(identifiedSubNetworkSizes.values());
            LOGGER.fine(String.format("remaining vertices %d, edges %d", this.theGraph.getVertices().size(), this.theGraph.getEdges().size()));
            for (Map.Entry entry : identifiedSubNetworkSizes.entrySet()) {
                int subNetworkSize = (Integer)entry.getValue();
                if (subNetworkSize >= maxSubNetworkSize && alwaysKeepLargest || subNetworkSize >= belowSize && subNetworkSize <= aboveSize) continue;
                removedDanglingNetworksBySize.putIfAbsent(subNetworkSize, new LongAdder());
                ((LongAdder)removedDanglingNetworksBySize.get(subNetworkSize)).increment();
                LOGGER.fine(String.format("removing %d vertices from graph", subNetworkSize));
                LOGGER.fine(String.format("remaining vertices %d, edges %d", this.theGraph.getVertices().size(), this.theGraph.getEdges().size()));
            }
            LongAdder totalCount = new LongAdder();
            removedDanglingNetworksBySize.forEach((size, count) -> {
                LOGGER.fine(String.format("sub graph size %d - %d removed", size, count.longValue()));
                totalCount.add(count.longValue());
            });
            LOGGER.fine(String.format("removed %d dangling sub graphs", totalCount.longValue()));
        } else {
            LOGGER.warning("no networks identified, unable to remove dangling subnetworks");
        }
    }

    public void removeSubGraph(Set<? extends Vertex> subGraphToRemove) {
        for (Vertex vertex : subGraphToRemove) {
            this.removeVertex(vertex);
            HashSet vertexEdges = new HashSet(vertex.getEdges());
            for (Edge edge : vertexEdges) {
                this.removeEdge(edge);
            }
            if (!this.hasListener((EventType)RemoveSubGraphEvent.EVENT_TYPE)) continue;
            this.fireEvent((Event)new RemoveSubGraphEvent(this));
        }
    }

    public void removeSubGraphOf(Vertex referenceVertex) {
        Set<Vertex> subNetworkNodesToRemove = this.processSubNetworkVertex(referenceVertex);
        this.removeSubGraph(subNetworkNodesToRemove);
    }

    public <Ex extends Edge> Map<Long, Pair<Ex, Ex>> breakEdgesAt(List<Ex> edgesToBreak, Vertex vertexToBreakAt, CoordinateReferenceSystem crs) {
        PlanitJtsCrsUtils geoUtils = new PlanitJtsCrsUtils(crs);
        TreeMap<Long, Pair<Ex, Ex>> affectedEdges = new TreeMap<Long, Pair<Ex, Ex>>();
        for (Edge edgeToBreak : edgesToBreak) {
            Edge breakToB;
            if (affectedEdges.containsKey(edgeToBreak.getId())) {
                LOGGER.severe(String.format("Edge (%s) cannot be broken twice at a single vertex, yet this appears to be the case", edgeToBreak.getXmlId()));
            }
            if ((breakToB = this.breakEdgeAt(vertexToBreakAt, edgeToBreak, geoUtils)) == null) continue;
            Edge aToBreak = edgeToBreak;
            affectedEdges.put(edgeToBreak.getId(), Pair.of((Object)aToBreak, (Object)breakToB));
        }
        return affectedEdges;
    }

    public <Ex extends Edge> Ex breakEdgeAt(Vertex vertexToBreakAt, Ex edgeToBreak, PlanitJtsCrsUtils geoUtils) {
        Ex aToBreak = edgeToBreak;
        Edge breakToB = (Edge)this.theGraph.getEdges().getFactory().createUniqueDeepCopyOf(edgeToBreak);
        this.theGraph.getEdges().register((Object)breakToB);
        if (edgeToBreak.getVertexA() == null || edgeToBreak.getVertexB() == null) {
            LOGGER.severe(String.format("unable to break edge since edge to break %s (id:%d) is missing one or more vertices", edgeToBreak.getExternalId(), edgeToBreak.getId()));
            return null;
        }
        Vertex oldVertexB = edgeToBreak.getVertexB();
        Vertex oldVertexA = edgeToBreak.getVertexA();
        aToBreak.replace(oldVertexB, vertexToBreakAt);
        breakToB.replace(oldVertexA, vertexToBreakAt);
        oldVertexB.replace(edgeToBreak, breakToB, true);
        oldVertexA.replace(edgeToBreak, aToBreak, true);
        vertexToBreakAt.addEdge(aToBreak);
        vertexToBreakAt.addEdge(breakToB);
        for (Edge brokenEdge : List.of(aToBreak, breakToB)) {
            GraphModifierImpl.updateBrokenEdgeGeometry(brokenEdge, vertexToBreakAt);
            brokenEdge.setLengthKm(geoUtils.getDistanceInKilometres(brokenEdge.getGeometry()));
        }
        if (this.hasListener((EventType)BreakEdgeEvent.EVENT_TYPE)) {
            this.fireEvent((Event)new BreakEdgeEvent(this, vertexToBreakAt, aToBreak, breakToB));
        }
        return (Ex)breakToB;
    }

    public void recreateManagedEntitiesIds() {
        if (this.theGraph.getEdges() instanceof ManagedIdEntities) {
            ((ManagedIdEntities)this.theGraph.getEdges()).recreateIds();
            this.fireEvent((Event)new RecreatedGraphEntitiesManagedIdsEvent(this, (ManagedIdEntities<? extends ManagedId>)((ManagedIdEntities)this.theGraph.getEdges())));
        }
        if (this.theGraph.getVertices() instanceof ManagedIdEntities) {
            ((ManagedIdEntities)this.theGraph.getVertices()).recreateIds();
            this.fireEvent((Event)new RecreatedGraphEntitiesManagedIdsEvent(this, (ManagedIdEntities<? extends ManagedId>)((ManagedIdEntities)this.theGraph.getVertices())));
        }
    }

    public void reset() {
        super.removeAllListeners();
    }

    public void addListener(GraphModifierListener listener) {
        super.addListener((EventListener)listener);
    }

    public void addListener(GraphModifierListener listener, GraphModifierEventType eventType) {
        super.addListener((EventListener)listener, new EventType[]{eventType});
    }

    public void removeListener(GraphModifierListener listener, GraphModifierEventType eventType) {
        super.removeListener((EventListener)listener, (EventType)eventType);
    }

    public void removeListener(GraphModifierListener listener) {
        super.removeListener((EventListener)listener);
    }
}

