/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.graph.directed.modifier;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.graph.directed.modifier.event.BreakEdgeSegmentEvent;
import org.goplanit.graph.directed.modifier.event.RecreatedDirectedGraphEntitiesManagedIdsEvent;
import org.goplanit.graph.directed.modifier.event.RemoveSubGraphEdgeSegmentEvent;
import org.goplanit.graph.modifier.GraphModifierImpl;
import org.goplanit.utils.event.Event;
import org.goplanit.utils.event.EventListener;
import org.goplanit.utils.event.EventProducerImpl;
import org.goplanit.utils.event.EventType;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.UntypedDirectedGraph;
import org.goplanit.utils.graph.UntypedGraph;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.graph.directed.DirectedEdge;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.graph.modifier.DirectedGraphModifier;
import org.goplanit.utils.graph.modifier.event.DirectedGraphModificationEvent;
import org.goplanit.utils.graph.modifier.event.DirectedGraphModifierEventType;
import org.goplanit.utils.graph.modifier.event.DirectedGraphModifierListener;
import org.goplanit.utils.graph.modifier.event.GraphModifierEventType;
import org.goplanit.utils.graph.modifier.event.GraphModifierListener;
import org.goplanit.utils.id.ManagedId;
import org.goplanit.utils.id.ManagedIdEntities;
import org.goplanit.utils.misc.Pair;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DirectedGraphModifierImpl
extends EventProducerImpl
implements DirectedGraphModifier {
    private static final Logger LOGGER = Logger.getLogger(DirectedGraphModifierImpl.class.getCanonicalName());
    private final GraphModifierImpl graphModifier;

    protected void fireEvent(EventListener eventListener, Event event) {
        if (event.getType() instanceof DirectedGraphModifierEventType) {
            ((DirectedGraphModifierListener)DirectedGraphModifierListener.class.cast(eventListener)).onDirectedGraphModificationEvent((DirectedGraphModificationEvent)DirectedGraphModificationEvent.class.cast(event));
        } else {
            this.graphModifier.fireEvent(eventListener, event);
        }
    }

    public UntypedDirectedGraph<?, ?, ?> getUntypedDirectedGraph() {
        return (UntypedDirectedGraph)this.graphModifier.getGraph();
    }

    private <Ex extends DirectedEdge> void updateBrokenEdgeItsEdgeSegments(Ex aToBreak, Ex breakToB) {
        DirectedVertex vertexAtBreak = aToBreak.getVertexB();
        ArrayList<EdgeSegment> identifiedEdgeSegmentOnEdge = new ArrayList<EdgeSegment>(2);
        for (Ex brokenEdge : List.of(aToBreak, breakToB)) {
            EdgeSegment oldEdgeSegmentBa;
            if (brokenEdge.hasEdgeSegmentAb()) {
                EdgeSegment oldEdgeSegmentAb;
                EdgeSegment newEdgeSegmentAb = oldEdgeSegmentAb = brokenEdge.getEdgeSegmentAb();
                if (identifiedEdgeSegmentOnEdge.contains(oldEdgeSegmentAb)) {
                    newEdgeSegmentAb = (EdgeSegment)this.getUntypedDirectedGraph().getEdgeSegments().getFactory().createUniqueDeepCopyOf((ManagedId)oldEdgeSegmentAb);
                    this.getUntypedDirectedGraph().getEdgeSegments().register((Object)newEdgeSegmentAb);
                    newEdgeSegmentAb.setParent(brokenEdge);
                } else {
                    identifiedEdgeSegmentOnEdge.add(newEdgeSegmentAb);
                }
                brokenEdge.replace(oldEdgeSegmentAb, newEdgeSegmentAb);
                newEdgeSegmentAb.setParent(brokenEdge);
                if (this.hasListener((EventType)BreakEdgeSegmentEvent.EVENT_TYPE)) {
                    this.fireEvent((Event)new BreakEdgeSegmentEvent(this, vertexAtBreak, newEdgeSegmentAb));
                }
            }
            if (!brokenEdge.hasEdgeSegmentBa()) continue;
            EdgeSegment newEdgeSegmentBa = oldEdgeSegmentBa = brokenEdge.getEdgeSegmentBa();
            if (identifiedEdgeSegmentOnEdge.contains(oldEdgeSegmentBa)) {
                newEdgeSegmentBa = (EdgeSegment)this.getUntypedDirectedGraph().getEdgeSegments().getFactory().createUniqueDeepCopyOf((ManagedId)oldEdgeSegmentBa);
                this.getUntypedDirectedGraph().getEdgeSegments().register((Object)newEdgeSegmentBa);
                newEdgeSegmentBa.setParent(brokenEdge);
            } else {
                identifiedEdgeSegmentOnEdge.add(newEdgeSegmentBa);
            }
            brokenEdge.replace(oldEdgeSegmentBa, newEdgeSegmentBa);
            newEdgeSegmentBa.setParent(brokenEdge);
            if (!this.hasListener((EventType)BreakEdgeSegmentEvent.EVENT_TYPE)) continue;
            this.fireEvent((Event)new BreakEdgeSegmentEvent(this, vertexAtBreak, newEdgeSegmentBa));
        }
    }

    public DirectedGraphModifierImpl(UntypedDirectedGraph<?, ?, ?> theDirectedGraph) {
        this.graphModifier = new GraphModifierImpl((UntypedGraph<?, ?>)theDirectedGraph);
    }

    public void removeVertex(DirectedVertex vertex) {
        this.graphModifier.removeVertex((Vertex)vertex);
    }

    public void removeEdge(DirectedEdge edge) {
        edge.removeEdgeSegments();
        this.graphModifier.removeEdge((Edge)edge);
    }

    public void removeEdgeSegment(EdgeSegment edgeSegment) {
        this.getUntypedDirectedGraph().getEdgeSegments().remove(edgeSegment.getId());
        if (edgeSegment.getParent() != null) {
            edgeSegment.getParent().removeEdgeSegment(edgeSegment);
        }
        edgeSegment.removeParentEdge();
        if (this.hasListener((EventType)RemoveSubGraphEdgeSegmentEvent.EVENT_TYPE)) {
            this.fireEvent((Event)new RemoveSubGraphEdgeSegmentEvent(this, edgeSegment));
        }
    }

    public void removeSubGraph(Set<? extends DirectedVertex> subGraphToRemove) {
        UntypedDirectedGraph<?, ?, ?> directedGraph = this.getUntypedDirectedGraph();
        for (DirectedVertex directedVertex : subGraphToRemove) {
            for (DirectedEdge directedEdge : directedVertex.getEdges()) {
                for (EdgeSegment edgeSegment : directedEdge.getEdgeSegments()) {
                    this.removeEdgeSegment(edgeSegment);
                }
            }
        }
        this.graphModifier.removeSubGraph(subGraphToRemove);
    }

    public void recreateManagedEntitiesIds() {
        this.graphModifier.recreateManagedEntitiesIds();
        if (this.getUntypedDirectedGraph().getEdgeSegments() instanceof ManagedIdEntities) {
            ((ManagedIdEntities)this.getUntypedDirectedGraph().getEdgeSegments()).recreateIds();
            this.fireEvent((Event)new RecreatedDirectedGraphEntitiesManagedIdsEvent(this, (ManagedIdEntities<? extends ManagedId>)((ManagedIdEntities)this.getUntypedDirectedGraph().getEdgeSegments())));
        }
    }

    public <Ex extends DirectedEdge> Ex breakEdgeAt(DirectedVertex vertexToBreakAt, Ex edgeToBreak, PlanitJtsCrsUtils geoUtils) {
        Ex aToBreak = edgeToBreak;
        Ex breakToB = this.graphModifier.breakEdgeAt((Vertex)vertexToBreakAt, edgeToBreak, geoUtils);
        this.updateBrokenEdgeItsEdgeSegments(aToBreak, breakToB);
        return breakToB;
    }

    public <Ex extends DirectedEdge> Map<Long, Pair<Ex, Ex>> breakEdgesAt(List<Ex> edgesToBreak, DirectedVertex vertexToBreakAt, CoordinateReferenceSystem crs) {
        Map<Long, Pair<Ex, Ex>> brokenEdges = this.graphModifier.breakEdgesAt(edgesToBreak, (Vertex)vertexToBreakAt, crs);
        brokenEdges.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(entry -> this.updateBrokenEdgeItsEdgeSegments((DirectedEdge)((Pair)entry.getValue()).first(), (DirectedEdge)((Pair)entry.getValue()).second()));
        return brokenEdges;
    }

    public void removeDanglingSubGraphs(Integer belowSize, Integer aboveSize, boolean alwaysKeepLargest) {
        this.graphModifier.removeDanglingSubGraphs(belowSize, aboveSize, alwaysKeepLargest);
    }

    public void removeSubGraphOf(DirectedVertex referenceVertex) throws PlanItException {
        this.graphModifier.removeSubGraphOf((Vertex)referenceVertex);
    }

    public void reset() {
        this.graphModifier.reset();
        this.removeAllListeners();
    }

    public void addListener(GraphModifierListener listener) {
        if (listener instanceof DirectedGraphModifierListener) {
            super.addListener((EventListener)listener);
        }
        if (listener instanceof GraphModifierListener) {
            this.graphModifier.addListener(listener);
        }
    }

    public void addListener(GraphModifierListener listener, GraphModifierEventType eventType) {
        if (listener instanceof DirectedGraphModifierListener) {
            super.addListener((EventListener)listener, new EventType[]{eventType});
        } else {
            this.graphModifier.addListener(listener, eventType);
        }
    }

    public void removeListener(GraphModifierListener listener, GraphModifierEventType eventType) {
        if (listener instanceof DirectedGraphModifierListener) {
            super.removeListener((EventListener)listener, (EventType)eventType);
        } else {
            this.graphModifier.removeListener(listener, eventType);
        }
    }

    public void removeListener(GraphModifierListener listener) {
        if (listener instanceof DirectedGraphModifierListener) {
            super.removeListener((EventListener)listener);
        } else {
            this.graphModifier.removeListener(listener);
        }
    }
}

