/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.graph.directed.acyclic;

import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.logging.Logger;
import org.goplanit.graph.directed.acyclic.AcyclicVertexData;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.graph.directed.acyclic.ACyclicSubGraph;
import org.goplanit.utils.graph.directed.acyclic.UntypedACyclicSubGraph;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;

public class UntypedACyclicSubGraphImpl<V extends DirectedVertex, E extends EdgeSegment>
implements UntypedACyclicSubGraph<V, E> {
    private static final Logger LOGGER = Logger.getLogger(UntypedACyclicSubGraphImpl.class.getCanonicalName());
    private final long id;
    private Map<V, AcyclicVertexData> vertexData;
    private ArrayDeque<V> topologicalOrder;
    private BitSet registeredLinkSegments;
    private Set<V> rootVertices;
    private boolean invertedDirection;

    private void resetVertexData() {
        for (AcyclicVertexData vertexData : this.vertexData.values()) {
            vertexData.postVisitIndex = 0L;
            vertexData.preVisitIndex = 0L;
        }
    }

    private void removeVertexData(V vertex) {
        this.vertexData.remove(vertex);
    }

    private boolean isConnectedToAnySubgraphEdgeSegment(V vertex) {
        for (EdgeSegment edgeSegment : vertex.getExitEdgeSegments()) {
            if (!this.containsEdgeSegment(edgeSegment)) continue;
            return true;
        }
        for (EdgeSegment edgeSegment : vertex.getEntryEdgeSegments()) {
            if (!this.containsEdgeSegment(edgeSegment)) continue;
            return true;
        }
        return false;
    }

    private boolean traverseRecursively(DirectedVertex vertex, BitSet visited, LongAdder counter, Deque<V> topologicalOrder) {
        visited.set((int)vertex.getId());
        AcyclicVertexData vertexData = this.getVertexData(vertex);
        if (vertexData == null) {
            throw new PlanItRunTimeException("No vertex data available for vertex %s, this shouldn't happen", new Object[]{vertex.toString()});
        }
        this.preVisit(vertexData, counter);
        Function getNextVertex = EdgeSegment.getVertexForEdgeSegmentLambda((boolean)this.isDirectionInverted());
        Function getNextEdgeSegments = DirectedVertex.getEdgeSegmentsForVertexLambda((boolean)this.isDirectionInverted());
        boolean isAcyclic = true;
        Iterable nextEdgeSegments = (Iterable)getNextEdgeSegments.apply(vertex);
        for (EdgeSegment nextEdgeSegment : nextEdgeSegments) {
            if (!this.containsEdgeSegment(nextEdgeSegment)) continue;
            DirectedVertex nextVertex = (DirectedVertex)getNextVertex.apply(nextEdgeSegment);
            AcyclicVertexData nextVertexData = this.getVertexData(nextVertex);
            if (nextVertexData.preVisitIndex == 0L) {
                isAcyclic = this.traverseRecursively(nextVertex, visited, counter, topologicalOrder);
            } else if (nextVertexData.postVisitIndex == 0L) {
                isAcyclic = false;
                LOGGER.warning(String.format("Cycle detected in supposed acyclic graph at vertex %s, terminating", nextVertex.getXmlId()));
            }
            if (isAcyclic) continue;
            return isAcyclic;
        }
        this.postVisit(vertexData, counter);
        topologicalOrder.push(vertex);
        return isAcyclic;
    }

    protected void postVisit(AcyclicVertexData vertexData, LongAdder counter) {
        vertexData.postVisitIndex = counter.intValue();
        counter.increment();
    }

    protected void preVisit(AcyclicVertexData vertexData, LongAdder counter) {
        vertexData.preVisitIndex = counter.intValue();
        counter.increment();
    }

    protected AcyclicVertexData getVertexData(DirectedVertex vertex) {
        return this.vertexData.get(vertex);
    }

    public UntypedACyclicSubGraphImpl(IdGroupingToken groupId, V rootVertex, boolean invertedDirection, int numberOfParentEdgeSegments) {
        this.id = IdGenerator.generateId((IdGroupingToken)groupId, ACyclicSubGraph.class);
        this.vertexData = new HashMap<V, AcyclicVertexData>();
        this.registeredLinkSegments = new BitSet(numberOfParentEdgeSegments);
        this.topologicalOrder = null;
        this.invertedDirection = invertedDirection;
        this.rootVertices = new HashSet<V>();
        this.rootVertices.add(rootVertex);
    }

    public UntypedACyclicSubGraphImpl(IdGroupingToken groupId, Set<V> rootVertices, boolean invertedDirection, int numberOfParentEdgeSegments) {
        this.id = IdGenerator.generateId((IdGroupingToken)groupId, ACyclicSubGraph.class);
        this.vertexData = new HashMap<V, AcyclicVertexData>();
        this.registeredLinkSegments = new BitSet(numberOfParentEdgeSegments);
        this.topologicalOrder = null;
        this.invertedDirection = invertedDirection;
        this.rootVertices = new HashSet<V>(rootVertices);
    }

    public UntypedACyclicSubGraphImpl(UntypedACyclicSubGraphImpl<V, E> other, boolean deepCopy) {
        this.id = other.getId();
        this.rootVertices = new HashSet<V>(other.rootVertices);
        this.invertedDirection = other.isDirectionInverted();
        this.registeredLinkSegments = BitSet.valueOf(other.registeredLinkSegments.toByteArray());
        this.vertexData = new HashMap<V, AcyclicVertexData>();
        other.vertexData.forEach((v, d) -> this.vertexData.put((AcyclicVertexData)v, deepCopy ? new AcyclicVertexData((AcyclicVertexData)d) : d));
        this.topologicalOrder = other.topologicalOrder != null ? new ArrayDeque<V>(other.topologicalOrder) : null;
    }

    public Deque<V> topologicalSort(boolean update) {
        if (!update && this.topologicalOrder != null && !this.topologicalOrder.isEmpty()) {
            return this.topologicalOrder;
        }
        this.topologicalOrder = new ArrayDeque(this.vertexData.size());
        this.resetVertexData();
        BitSet visited = new BitSet(this.vertexData.size());
        LongAdder counter = new LongAdder();
        boolean isAcyclic = true;
        counter.increment();
        for (DirectedVertex directedVertex : this.rootVertices) {
            isAcyclic = this.traverseRecursively(directedVertex, visited, counter, this.topologicalOrder);
            if (isAcyclic) continue;
            return null;
        }
        for (Map.Entry entry : this.vertexData.entrySet()) {
            if (visited.get((int)((DirectedVertex)entry.getKey()).getId())) continue;
            LOGGER.warning(String.format("Topological sort applied, but some vertices not connected to a root of the acyclic graph (%d), unable to determine sorting order", this.getId()));
            return null;
        }
        return this.topologicalOrder;
    }

    public long getId() {
        return this.id;
    }

    public void addEdgeSegment(E edgeSegment) {
        if (edgeSegment == null) {
            LOGGER.warning("Unable to add edge segment to acyclic subgraph, null provided");
            return;
        }
        this.registeredLinkSegments.set((int)edgeSegment.getId());
        if (!this.vertexData.containsKey(edgeSegment.getUpstreamVertex())) {
            this.vertexData.put((AcyclicVertexData)edgeSegment.getUpstreamVertex(), new AcyclicVertexData());
        }
        if (!this.vertexData.containsKey(edgeSegment.getDownstreamVertex())) {
            this.vertexData.put((AcyclicVertexData)edgeSegment.getDownstreamVertex(), new AcyclicVertexData());
        }
    }

    public boolean containsEdgeSegment(EdgeSegment edgeSegment) {
        if (edgeSegment == null) {
            return false;
        }
        return this.registeredLinkSegments.get((int)edgeSegment.getId());
    }

    public long getNumberOfVertices() {
        return this.vertexData.size();
    }

    public Iterator<V> iterator() {
        return Collections.unmodifiableSet(this.vertexData.keySet()).iterator();
    }

    public void removeEdgeSegment(E edgeSegment) {
        this.registeredLinkSegments.set((int)edgeSegment.getId(), false);
        if (!this.isConnectedToAnySubgraphEdgeSegment(edgeSegment.getDownstreamVertex())) {
            this.removeVertexData(edgeSegment.getDownstreamVertex());
        }
        if (!this.isConnectedToAnySubgraphEdgeSegment(edgeSegment.getUpstreamVertex())) {
            this.removeVertexData(edgeSegment.getUpstreamVertex());
        }
    }

    public UntypedACyclicSubGraphImpl<V, E> shallowClone() {
        return new UntypedACyclicSubGraphImpl<V, E>(this, false);
    }

    public UntypedACyclicSubGraphImpl<V, E> deepClone() {
        LOGGER.severe("Not a smart deep clone on untyped acyclic sub graph, so interdependencies will get screwed up, recommend not to use until properly implemented");
        return new UntypedACyclicSubGraphImpl<V, E>(this, true);
    }

    public Set<V> getRootVertices() {
        return this.rootVertices;
    }

    public boolean isDirectionInverted() {
        return this.invertedDirection;
    }

    public void addRootVertex(V rootVertex) {
        this.rootVertices.add(rootVertex);
    }
}

