/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.graph.directed;

import java.util.logging.Logger;
import org.goplanit.graph.UntypedGraphImpl;
import org.goplanit.utils.graph.GraphEntities;
import org.goplanit.utils.graph.GraphEntityDeepCopyMapper;
import org.goplanit.utils.graph.UntypedDirectedGraph;
import org.goplanit.utils.graph.directed.DirectedEdge;
import org.goplanit.utils.graph.directed.DirectedEdgeUtils;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.graph.directed.EdgeSegmentUtils;
import org.goplanit.utils.id.IdGroupingToken;

public class UntypedDirectedGraphImpl<V extends DirectedVertex, E extends DirectedEdge, ES extends EdgeSegment>
extends UntypedGraphImpl<V, E>
implements UntypedDirectedGraph<V, E, ES> {
    private static final Logger LOGGER = Logger.getLogger(UntypedDirectedGraphImpl.class.getCanonicalName());
    protected final GraphEntities<ES> edgeSegments;

    public UntypedDirectedGraphImpl(IdGroupingToken groupToken, GraphEntities<V> vertices, GraphEntities<E> edges, GraphEntities<ES> edgeSegments) {
        super(groupToken, vertices, edges);
        this.edgeSegments = edgeSegments;
    }

    public UntypedDirectedGraphImpl(UntypedDirectedGraphImpl<V, E, ES> directedGraphImpl, boolean deepCopy) {
        this(directedGraphImpl, deepCopy, null, null, null);
    }

    public UntypedDirectedGraphImpl(UntypedDirectedGraphImpl<V, E, ES> directedGraphImpl, boolean deepCopy, GraphEntityDeepCopyMapper<V> vertexMapper, GraphEntityDeepCopyMapper<E> edgeMapper, GraphEntityDeepCopyMapper<ES> edgeSegmentMapper) {
        super(directedGraphImpl, deepCopy, vertexMapper, edgeMapper);
        if (deepCopy) {
            this.edgeSegments = directedGraphImpl.getEdgeSegments().deepCloneWithMapping(edgeSegmentMapper);
            EdgeSegmentUtils.updateEdgeSegmentParentEdges(this.edgeSegments, originalEdge -> (DirectedEdge)edgeMapper.getMapping(originalEdge), (boolean)true);
            DirectedEdgeUtils.updateDirectedEdgeEdgeSegments((Iterable)this.edges, originalEdgeSegment -> (EdgeSegment)edgeSegmentMapper.getMapping(originalEdgeSegment), (boolean)true);
        } else {
            this.edgeSegments = directedGraphImpl.getEdgeSegments().shallowClone();
        }
    }

    public GraphEntities<ES> getEdgeSegments() {
        return this.edgeSegments;
    }

    public UntypedDirectedGraphImpl<V, E, ES> shallowClone() {
        return new UntypedDirectedGraphImpl<V, E, ES>(this, false);
    }

    public UntypedDirectedGraphImpl<V, E, ES> deepClone() {
        return new UntypedDirectedGraphImpl<V, E, ES>(this, true);
    }

    public UntypedDirectedGraphImpl<V, E, ES> smartDeepClone(GraphEntityDeepCopyMapper<V> vertexMapper, GraphEntityDeepCopyMapper<E> edgeMapper, GraphEntityDeepCopyMapper<ES> edgeSegmentMapper) {
        return new UntypedDirectedGraphImpl<V, E, ES>(this, true, vertexMapper, edgeMapper, edgeSegmentMapper);
    }
}

