/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.graph.directed;

import java.util.logging.Logger;
import org.goplanit.graph.GraphEntityImpl;
import org.goplanit.utils.graph.directed.DirectedEdge;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.id.IdGroupingToken;

public class EdgeSegmentImpl<E extends DirectedEdge>
extends GraphEntityImpl
implements EdgeSegment {
    private static final long serialVersionUID = -6521489123632246969L;
    private static final Logger LOGGER = Logger.getLogger(EdgeSegmentImpl.class.getCanonicalName());
    private boolean directionAb;
    private E parentEdge;

    protected static final boolean validate(EdgeSegment edgeSegment) {
        if (edgeSegment.getParent() == null) {
            LOGGER.warning(String.format("parent edge missing on edge segment (id:%d externalId:%s)", edgeSegment.getId(), edgeSegment.getExternalId()));
            return false;
        }
        if (edgeSegment.getUpstreamVertex() == null) {
            LOGGER.warning(String.format("upstream vertex missing on edge segment (id:%d externalId:%s)", edgeSegment.getId(), edgeSegment.getExternalId()));
            return false;
        }
        if (edgeSegment.getDownstreamVertex() == null) {
            LOGGER.warning(String.format("downstream vertex missing on edge segment (id:%d externalId:%s)", edgeSegment.getId(), edgeSegment.getExternalId()));
            return false;
        }
        if (edgeSegment.getParent().getVertexA() == edgeSegment.getUpstreamVertex() && edgeSegment.isDirectionAb()) {
            if (edgeSegment.getParent().getEdgeSegmentAb() == null) {
                LOGGER.warning(String.format("edge segment A->B on parent edge of this edge segment (id:%d externalId:%s) should be the same but it is null", edgeSegment.getId(), edgeSegment.getExternalId()));
                return false;
            }
            if (!edgeSegment.getParent().getEdgeSegmentAb().equals(edgeSegment)) {
                LOGGER.warning(String.format("edge segment A->B on parent edge of this edge segment (id:%d externalId:%s) should be the same but it is not", edgeSegment.getId(), edgeSegment.getExternalId()));
                return false;
            }
        } else if (edgeSegment.getParent().getVertexB() == edgeSegment.getUpstreamVertex() && !edgeSegment.isDirectionAb()) {
            if (edgeSegment.getParent().getEdgeSegmentBa() == null) {
                LOGGER.warning(String.format("edge segment A->B on parent edge of this edge segment (id:%d externalId:%s) should be the same but it is null", edgeSegment.getId(), edgeSegment.getExternalId()));
                return false;
            }
            if (!edgeSegment.getParent().getEdgeSegmentBa().equals(edgeSegment)) {
                LOGGER.warning(String.format("edge segment B->A on parent edge of this edge segment (id:%d externalId:%s) should be the same but it is not", edgeSegment.getId(), edgeSegment.getExternalId()));
                return false;
            }
        } else {
            LOGGER.warning(String.format("edge segment direction inconsistent with its vertices (id:%d externalId:%s) should be the same but it is not", edgeSegment.getId(), edgeSegment.getExternalId()));
        }
        if (edgeSegment.getParent().getVertexA().equals(edgeSegment.getUpstreamVertex())) {
            if (!edgeSegment.getParent().getVertexB().equals(edgeSegment.getDownstreamVertex())) {
                LOGGER.warning(String.format("edge segment (id:%d externalId:%s) vertices do not match with parent edge vertices", edgeSegment.getId(), edgeSegment.getExternalId()));
                return false;
            }
        } else if (!edgeSegment.getParent().getVertexB().equals(edgeSegment.getUpstreamVertex()) || !edgeSegment.getParent().getVertexA().equals(edgeSegment.getDownstreamVertex())) {
            LOGGER.warning(String.format("edge segment (id:%d externalId:%s) vertices do not match with parent edge vertices", edgeSegment.getId(), edgeSegment.getExternalId()));
            return false;
        }
        return true;
    }

    protected EdgeSegmentImpl(IdGroupingToken groupId, E parentEdge, boolean directionAb, Class<? extends EdgeSegment> idClazz) {
        super(groupId, EDGE_SEGMENT_ID_CLASS);
        this.setParent((DirectedEdge)parentEdge);
        this.directionAb = directionAb;
    }

    protected EdgeSegmentImpl(IdGroupingToken groupId, E parentEdge, boolean directionAb) {
        this(groupId, parentEdge, directionAb, EDGE_SEGMENT_ID_CLASS);
    }

    protected EdgeSegmentImpl(IdGroupingToken groupId, boolean directionAb) {
        this(groupId, null, directionAb);
    }

    protected EdgeSegmentImpl(EdgeSegmentImpl<E> edgeSegmentImpl, boolean deepCopy) {
        super(edgeSegmentImpl, deepCopy);
        this.setParent((DirectedEdge)edgeSegmentImpl.getParent());
        this.directionAb = edgeSegmentImpl.directionAb;
    }

    public boolean isDirectionAb() {
        return this.directionAb;
    }

    public E getParent() {
        return this.parentEdge;
    }

    public void setParent(DirectedEdge parentEdge) {
        if (parentEdge == null) {
            LOGGER.warning(String.format("Parent edge is null, unable to set on edge segment (id: %d)", this.getId()));
            return;
        }
        this.parentEdge = parentEdge;
    }

    public void removeParentEdge() {
        this.parentEdge = null;
    }

    @Override
    public EdgeSegmentImpl<E> shallowClone() {
        return new EdgeSegmentImpl<E>(this, false);
    }

    @Override
    public EdgeSegmentImpl<E> deepClone() {
        return new EdgeSegmentImpl<E>(this, true);
    }

    public boolean validate() {
        return EdgeSegmentImpl.validate(this);
    }
}

