/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.graph.directed;

import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;
import org.goplanit.graph.VertexImpl;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.graph.directed.DirectedEdge;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.id.IdGroupingToken;

public class DirectedVertexImpl<E extends EdgeSegment>
extends VertexImpl<Edge>
implements DirectedVertex {
    private static final long serialVersionUID = 2165199386965239623L;
    private static final Logger LOGGER = Logger.getLogger(DirectedVertexImpl.class.getCanonicalName());
    protected final EdgeSegmentIterable<E> entryEdgeSegments;
    protected final EdgeSegmentIterable<E> exitEdgeSegments;

    protected DirectedVertexImpl(IdGroupingToken groupId, Class<? extends Vertex> idClazz) {
        super(groupId, idClazz);
        this.entryEdgeSegments = new EdgeSegmentIterable(true);
        this.exitEdgeSegments = new EdgeSegmentIterable(false);
    }

    protected DirectedVertexImpl(IdGroupingToken groupId) {
        this(groupId, (Class<Vertex>)((Class<? extends Vertex>)VERTEX_ID_CLASS));
    }

    protected DirectedVertexImpl(long id) {
        super(id);
        this.entryEdgeSegments = new EdgeSegmentIterable(true);
        this.exitEdgeSegments = new EdgeSegmentIterable(false);
    }

    protected DirectedVertexImpl(DirectedVertexImpl<E> directedVertexImpl, boolean deepCopy) {
        super(directedVertexImpl, deepCopy);
        this.entryEdgeSegments = directedVertexImpl.entryEdgeSegments.shallowClone();
        this.exitEdgeSegments = directedVertexImpl.exitEdgeSegments.shallowClone();
    }

    public Iterable<E> getEntryEdgeSegments() {
        return this.entryEdgeSegments;
    }

    public Iterable<E> getExitEdgeSegments() {
        return this.exitEdgeSegments;
    }

    @Override
    public Collection<? extends DirectedEdge> getEdges() {
        return super.getEdges();
    }

    @Override
    public DirectedVertexImpl<E> shallowClone() {
        return new DirectedVertexImpl<E>(this, false);
    }

    @Override
    public DirectedVertexImpl<E> deepClone() {
        return new DirectedVertexImpl<E>(this, true);
    }

    public class EdgeSegmentIterator<ES extends EdgeSegment>
    implements Iterator<ES> {
        private Iterator<? extends DirectedEdge> edgesIter;
        private boolean incoming;
        private ES nextEdgeSegment;

        private EdgeSegmentIterator(boolean incoming) {
            this.incoming = incoming;
            this.edgesIter = DirectedVertexImpl.this.getEdges().iterator();
            this.nextEdgeSegment = null;
            this.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            if (this.nextEdgeSegment != null) {
                return true;
            }
            while (this.edgesIter.hasNext()) {
                DirectedEdge edge = this.edgesIter.next();
                if (edge.getVertexA() == DirectedVertexImpl.this) {
                    this.nextEdgeSegment = this.incoming ? edge.getEdgeSegmentBa() : edge.getEdgeSegmentAb();
                } else if (edge.getVertexB() == DirectedVertexImpl.this) {
                    this.nextEdgeSegment = this.incoming ? edge.getEdgeSegmentAb() : edge.getEdgeSegmentBa();
                } else {
                    LOGGER.severe(String.format("Vertex (%s) not present on edge (%s) it holds, this shouldn't happen", DirectedVertexImpl.this.getXmlId(), edge.getXmlId()));
                }
                if (this.nextEdgeSegment == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public ES next() {
            ES returnEdgeSegment = this.nextEdgeSegment;
            this.nextEdgeSegment = null;
            return returnEdgeSegment;
        }
    }

    public final class EdgeSegmentIterable<ESI extends EdgeSegment>
    implements Iterable<ESI> {
        boolean incoming;

        private EdgeSegmentIterable(boolean incoming) {
            this.incoming = incoming;
        }

        private EdgeSegmentIterable(EdgeSegmentIterable other) {
            this(other.incoming);
        }

        @Override
        public EdgeSegmentIterator<ESI> iterator() {
            return new EdgeSegmentIterator(this.incoming);
        }

        public EdgeSegmentIterable<ESI> shallowClone() {
            return new EdgeSegmentIterable<ESI>(this);
        }
    }
}

