/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.graph.directed;

import java.util.logging.Logger;
import org.goplanit.graph.EdgeImpl;
import org.goplanit.utils.graph.directed.DirectedEdge;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.id.IdGroupingToken;

public class DirectedEdgeImpl<V extends DirectedVertex, ES extends EdgeSegment>
extends EdgeImpl<V>
implements DirectedEdge {
    private static final long serialVersionUID = -3061186642253968991L;
    private static final Logger LOGGER = Logger.getLogger(DirectedEdgeImpl.class.getCanonicalName());
    private ES edgeSegmentAb = null;
    private ES edgeSegmentBa = null;

    protected DirectedEdgeImpl(IdGroupingToken groupId, V vertexA, V vertexB) {
        super(groupId, vertexA, vertexB);
    }

    protected DirectedEdgeImpl(IdGroupingToken groupId, V vertexA, V vertexB, double lengthKm) {
        super(groupId, vertexA, vertexB, lengthKm);
    }

    protected DirectedEdgeImpl(DirectedEdgeImpl<V, ES> directedEdgeImpl, boolean deepCopy) {
        super(directedEdgeImpl, deepCopy);
        this.setEdgeSegmentAb(directedEdgeImpl.getEdgeSegmentAb());
        this.setEdgeSegmentBa(directedEdgeImpl.getEdgeSegmentBa());
    }

    public void setEdgeSegmentBa(ES edgeSegmentBa) {
        this.edgeSegmentBa = edgeSegmentBa;
    }

    public void setEdgeSegmentAb(ES edgeSegmentAb) {
        this.edgeSegmentAb = edgeSegmentAb;
    }

    public ES registerEdgeSegment(EdgeSegment edgeSegment, boolean directionAB, boolean force) {
        ES overwrittenEdgeSegment;
        if (edgeSegment != null && edgeSegment.getParent() == null) {
            edgeSegment.setParent((DirectedEdge)this);
        }
        if (!(force || edgeSegment != null && edgeSegment.getParent() == this)) {
            LOGGER.warning("Inconsistency between link segment's parent link and link it is being registered on");
            return null;
        }
        ES ES = overwrittenEdgeSegment = directionAB ? this.getEdgeSegmentAb() : this.getEdgeSegmentBa();
        if (directionAB) {
            this.setEdgeSegmentAb(edgeSegment);
        } else {
            this.setEdgeSegmentBa(edgeSegment);
        }
        return overwrittenEdgeSegment;
    }

    public ES getEdgeSegmentAb() {
        return this.edgeSegmentAb;
    }

    public ES getEdgeSegmentBa() {
        return this.edgeSegmentBa;
    }

    @Override
    public DirectedEdgeImpl<V, ES> shallowClone() {
        return new DirectedEdgeImpl<V, ES>(this, false);
    }

    @Override
    public DirectedEdgeImpl<V, ES> deepClone() {
        return new DirectedEdgeImpl<V, ES>(this, true);
    }

    public void replace(EdgeSegment edgeSegmentToReplace, EdgeSegment edgeSegmentToReplaceWith) {
        if (edgeSegmentToReplace != null) {
            if (this.hasEdgeSegmentAb() && this.getEdgeSegmentAb().getId() == edgeSegmentToReplace.getId()) {
                this.setEdgeSegmentAb(edgeSegmentToReplaceWith);
            } else if (this.hasEdgeSegmentBa() && this.getEdgeSegmentBa().getId() == edgeSegmentToReplace.getId()) {
                this.setEdgeSegmentBa(edgeSegmentToReplaceWith);
            } else {
                LOGGER.warning("provided edge segment to replace is not known on the directed edge");
            }
        }
    }

    public ES removeEdgeSegmentAb() {
        ES removedEdgeSegment = this.edgeSegmentAb;
        this.setEdgeSegmentAb(null);
        return removedEdgeSegment;
    }

    public ES removeEdgeSegmentBa() {
        ES removedEdgeSegment = this.edgeSegmentBa;
        this.setEdgeSegmentBa(null);
        return removedEdgeSegment;
    }
}

