/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.graph.directed;

import java.util.logging.Logger;
import org.goplanit.graph.directed.DirectedEdgeImpl;
import org.goplanit.utils.graph.directed.ConjugateDirectedEdge;
import org.goplanit.utils.graph.directed.ConjugateDirectedVertex;
import org.goplanit.utils.graph.directed.ConjugateEdgeSegment;
import org.goplanit.utils.graph.directed.DirectedEdge;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.Pair;
import org.locationtech.jts.geom.LineString;

public class ConjugateDirectedEdgeImpl<V extends ConjugateDirectedVertex, ES extends ConjugateEdgeSegment>
extends DirectedEdgeImpl<V, ES>
implements ConjugateDirectedEdge {
    private static final long serialVersionUID = -3061186642253968991L;
    private static final Logger LOGGER = Logger.getLogger(ConjugateDirectedEdgeImpl.class.getCanonicalName());
    protected final Pair<DirectedEdge, DirectedEdge> originalEdges;

    protected ConjugateDirectedEdgeImpl(IdGroupingToken groupId, V vertexA, V vertexB, DirectedEdge originalEdge1, DirectedEdge originalEdge2) {
        super(groupId, vertexA, vertexB);
        this.originalEdges = Pair.of((Object)originalEdge1, (Object)originalEdge2);
    }

    protected ConjugateDirectedEdgeImpl(ConjugateDirectedEdgeImpl<V, ES> other, boolean deepCopy) {
        super(other, deepCopy);
        this.originalEdges = other.originalEdges.copy();
    }

    @Override
    public double getLengthKm() {
        LOGGER.warning("Length of conjugate is combination of underlying original geometries/lengths, collect those instead, negative infinity returned");
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public void setLengthKm(double lengthInKm) {
        LOGGER.warning("Length of conjugate is combination of underlying original geometries/lengths, set those instead");
    }

    @Override
    public LineString getGeometry() {
        LOGGER.warning("Geometry of conjugate is combination of underlying original geometries, collect those instead, null returned");
        return null;
    }

    @Override
    public void setGeometry(LineString geometry) {
        LOGGER.warning("Geometry of conjugate is combination of underlying original geometries, set those instead");
    }

    public Pair<DirectedEdge, DirectedEdge> getOriginalAdjacentEdges() {
        return this.originalEdges;
    }

    @Override
    public ConjugateDirectedEdgeImpl<V, ES> shallowClone() {
        return new ConjugateDirectedEdgeImpl<V, ES>(this, false);
    }

    @Override
    public ConjugateDirectedEdgeImpl<V, ES> deepClone() {
        return new ConjugateDirectedEdgeImpl<V, ES>(this, true);
    }
}

