/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.goplanit.graph.GraphEntityImpl;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.CloneUtils;
import org.locationtech.jts.geom.Point;

public class VertexImpl<E extends Edge>
extends GraphEntityImpl
implements Vertex {
    private static final long serialVersionUID = -2877566769607366608L;
    protected Map<String, Object> inputProperties = null;
    protected Point position;
    protected final ArrayList<E> edges = new ArrayList(2);

    protected VertexImpl(IdGroupingToken groupId) {
        super(groupId, VERTEX_ID_CLASS);
    }

    protected VertexImpl(IdGroupingToken groupId, Class<? extends Vertex> vertexIdClass) {
        super(groupId, vertexIdClass);
    }

    protected VertexImpl(long id) {
        super(id);
    }

    protected VertexImpl(VertexImpl<E> other, boolean deepCopy) {
        super(other, deepCopy);
        this.edges.addAll(other.edges);
        this.setPosition(deepCopy ? (Point)other.getPosition().copy() : other.getPosition());
        if (other.inputProperties != null && !other.inputProperties.isEmpty()) {
            if (deepCopy) {
                CloneUtils.deepCloneFromTo(other.inputProperties, this.inputProperties);
            } else {
                this.inputProperties.putAll(other.inputProperties);
            }
        }
    }

    public Point getPosition() {
        return this.position;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public void addInputProperty(String key, Object value) {
        if (this.inputProperties == null) {
            this.inputProperties = new HashMap<String, Object>();
        }
        this.inputProperties.put(key, value);
    }

    public Object getInputProperty(String key) {
        return this.inputProperties.get(key);
    }

    public boolean addEdge(Edge edge) {
        if (this.edges.contains(edge)) {
            return false;
        }
        this.edges.add(edge);
        return true;
    }

    public boolean removeEdge(long edgeId) {
        return this.edges.removeIf(e -> e.getId() == edgeId);
    }

    public void removeAllEdges() {
        this.edges.clear();
    }

    public Collection<? extends E> getEdges() {
        return Collections.unmodifiableCollection(this.edges);
    }

    @Override
    public VertexImpl<E> shallowClone() {
        return new VertexImpl<E>(this, false);
    }

    @Override
    public VertexImpl<E> deepClone() {
        return new VertexImpl<E>(this, true);
    }
}

