/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.graph;

import java.util.logging.Logger;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.EdgeUtils;
import org.goplanit.utils.graph.GraphEntities;
import org.goplanit.utils.graph.GraphEntityDeepCopyMapper;
import org.goplanit.utils.graph.UntypedGraph;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.graph.VertexUtils;
import org.goplanit.utils.id.IdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;

public class UntypedGraphImpl<V extends Vertex, E extends Edge>
extends IdAbleImpl
implements UntypedGraph<V, E> {
    private static final Logger LOGGER = Logger.getLogger(UntypedGraphImpl.class.getCanonicalName());
    private final IdGroupingToken groupId;
    protected final GraphEntities<E> edges;
    protected final GraphEntities<V> vertices;

    protected static long generatedGraphId(IdGroupingToken groupId) {
        return IdGenerator.generateId((IdGroupingToken)groupId, (Class)GRAPH_ID_CLASS);
    }

    public UntypedGraphImpl(IdGroupingToken groupId, GraphEntities<V> vertices, GraphEntities<E> edges) {
        super(UntypedGraphImpl.generatedGraphId(groupId));
        this.groupId = groupId;
        this.edges = edges;
        this.vertices = vertices;
    }

    public UntypedGraphImpl(UntypedGraphImpl<V, E> other, boolean deepCopy) {
        this(other, deepCopy, null, null);
    }

    public UntypedGraphImpl(UntypedGraphImpl<V, E> other, boolean deepCopy, GraphEntityDeepCopyMapper<V> vertexMapper, GraphEntityDeepCopyMapper<E> edgesMapper) {
        super(other);
        if (deepCopy) {
            this.vertices = other.getVertices().deepCloneWithMapping(vertexMapper);
            this.edges = other.getEdges().deepCloneWithMapping(edgesMapper);
            EdgeUtils.updateEdgeVertices(this.edges, originalVertex -> (Vertex)vertexMapper.getMapping(originalVertex), (boolean)true);
            VertexUtils.updateVertexEdges(this.vertices, originalEdge -> (Edge)edgesMapper.getMapping(originalEdge), (boolean)true);
        } else {
            this.edges = other.getEdges().shallowClone();
            this.vertices = other.getVertices().shallowClone();
        }
        this.groupId = other.groupId;
    }

    public IdGroupingToken getGraphIdGroupingToken() {
        return this.groupId;
    }

    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = UntypedGraphImpl.generatedGraphId(tokenId);
        this.setId(newId);
        return newId;
    }

    public Class<UntypedGraph> getIdClass() {
        return UntypedGraph.GRAPH_ID_CLASS;
    }

    public GraphEntities<V> getVertices() {
        return this.vertices;
    }

    public GraphEntities<E> getEdges() {
        return this.edges;
    }

    public UntypedGraph<V, E> shallowClone() {
        return new UntypedGraphImpl<V, E>(this, false);
    }

    public UntypedGraph<V, E> deepClone() {
        return new UntypedGraphImpl<V, E>(this, true);
    }

    public UntypedGraphImpl<V, E> smartDeepClone(GraphEntityDeepCopyMapper<V> vertexMapper, GraphEntityDeepCopyMapper<E> edgeMapper) {
        return new UntypedGraphImpl<V, E>(this, true, vertexMapper, edgeMapper);
    }
}

