/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.graph;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.graph.GraphEntityImpl;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.CloneUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;

public class EdgeImpl<V extends Vertex>
extends GraphEntityImpl
implements Edge {
    private static final Logger LOGGER = Logger.getLogger(EdgeImpl.class.getCanonicalName());
    private static final long serialVersionUID = -3061186642253968991L;
    private V vertexA = null;
    private V vertexB = null;
    protected LineString lineGeometry;
    protected Map<String, Object> inputProperties = null;
    protected String name = "";
    protected Double lengthInKm;

    protected void setVertexB(V vertexB) {
        this.vertexB = vertexB;
    }

    protected void setVertexA(V vertexA) {
        this.vertexA = vertexA;
    }

    protected EdgeImpl(IdGroupingToken groupId, V vertexA, V vertexB) {
        super(groupId, EDGE_ID_CLASS);
        this.vertexA = vertexA;
        this.vertexB = vertexB;
        this.lengthInKm = null;
        this.lineGeometry = null;
    }

    protected EdgeImpl(IdGroupingToken groupId, V vertexA, V vertexB, double lengthKm) {
        this(groupId, vertexA, vertexB);
        this.lengthInKm = lengthKm;
    }

    protected EdgeImpl(EdgeImpl<V> other, boolean deepCopy) {
        super(other, deepCopy);
        this.setGeometry(other.hasGeometry() && deepCopy ? (LineString)other.getGeometry().copy() : other.lineGeometry);
        this.vertexA = other.vertexA;
        this.vertexB = other.vertexB;
        this.lengthInKm = other.lengthInKm;
        this.name = other.name;
        if (other.inputProperties != null && !other.inputProperties.isEmpty()) {
            for (Map.Entry<String, Object> entry : other.inputProperties.entrySet()) {
                this.addInputProperty(entry.getKey(), deepCopy ? CloneUtils.deepClone((Object)entry.getValue()) : entry.getValue());
            }
        }
    }

    public LineString getGeometry() {
        return this.lineGeometry;
    }

    public void setGeometry(LineString lineString) {
        this.lineGeometry = lineString;
    }

    public boolean removeVertex(Vertex vertex) {
        if (vertex != null) {
            if (this.getVertexA() != null && this.getVertexA().getId() == vertex.getId()) {
                return this.removeVertexA();
            }
            if (this.getVertexB() != null && this.getVertexB().getId() == vertex.getId()) {
                return this.removeVertexB();
            }
        }
        return false;
    }

    public boolean removeVertexB() {
        this.setVertexB(null);
        return true;
    }

    public boolean removeVertexA() {
        this.setVertexA(null);
        return true;
    }

    public void addInputProperty(String key, Object value) {
        if (this.inputProperties == null) {
            this.inputProperties = new HashMap<String, Object>();
        }
        this.inputProperties.put(key, value);
    }

    public Object getInputProperty(String key) {
        if (this.inputProperties == null) {
            return null;
        }
        return this.inputProperties.get(key);
    }

    public double getLengthKm() {
        return this.lengthInKm;
    }

    public void setLengthKm(double lengthInKm) {
        this.lengthInKm = lengthInKm;
    }

    public V getVertexA() {
        return this.vertexA;
    }

    public V getVertexB() {
        return this.vertexB;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean replace(Vertex vertexToReplace, Vertex vertexToReplaceWith) {
        boolean vertexReplaced = false;
        if (vertexToReplaceWith != null) {
            if (this.getVertexA() != null && vertexToReplace.getId() == this.getVertexA().getId()) {
                this.removeVertex(vertexToReplace);
                this.setVertexA(vertexToReplaceWith);
                vertexReplaced = true;
            } else if (this.getVertexB() != null && vertexToReplace.getId() == this.getVertexB().getId()) {
                this.removeVertex(vertexToReplace);
                this.setVertexB(vertexToReplaceWith);
                vertexReplaced = true;
            }
        }
        return vertexReplaced;
    }

    @Override
    public EdgeImpl<V> shallowClone() {
        return new EdgeImpl<V>(this, false);
    }

    @Override
    public EdgeImpl<V> deepClone() {
        return new EdgeImpl<V>(this, true);
    }

    public boolean validate() {
        if (this.getVertexA() == null) {
            LOGGER.warning(String.format("Vertex A missing on edge (id:%d externalId:%s)", this.getId(), this.getExternalId()));
            return false;
        }
        if (this.getVertexB() == null) {
            LOGGER.warning(String.format("Vertex B missing on edge segment (id:%d externalId:%s)", this.getId(), this.getExternalId()));
            return false;
        }
        if (this.getVertexA().getEdges(this.getVertexB()) == null || !this.getVertexA().getEdges(this.getVertexB()).contains((Object)this)) {
            LOGGER.warning(String.format("Edge (id:%d externalId:%s) not registered on vertex A", this.getId(), this.getExternalId()));
            return false;
        }
        if (this.getVertexB().getEdges(this.getVertexA()) == null || !this.getVertexB().getEdges(this.getVertexA()).contains((Object)this)) {
            LOGGER.warning(String.format("Edge (id:%d externalId:%s) not registered on vertex B", this.getId(), this.getExternalId()));
            return false;
        }
        if (!(this.getGeometry() == null || this.getGeometry().isWithinDistance((Geometry)this.getVertexB().getPosition(), 1.0E-6) && this.getGeometry().isWithinDistance((Geometry)this.getVertexB().getPosition(), 1.0E-6))) {
            LOGGER.warning(String.format("Edge (id:%d externalId:%s) internal geometry does not cover its vertices", this.getId(), this.getExternalId()));
        }
        return true;
    }
}

