/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.graph;

import java.util.logging.Logger;
import org.goplanit.graph.EdgeImpl;
import org.goplanit.utils.graph.ConjugateEdge;
import org.goplanit.utils.graph.ConjugateVertex;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.Pair;
import org.locationtech.jts.geom.LineString;

public class ConjugateEdgeImpl<V extends ConjugateVertex>
extends EdgeImpl<V>
implements ConjugateEdge {
    private static final long serialVersionUID = -8689706463623986248L;
    private static final Logger LOGGER = Logger.getLogger(ConjugateEdgeImpl.class.getCanonicalName());
    protected final Pair<Edge, Edge> originalEdges;

    protected ConjugateEdgeImpl(IdGroupingToken groupId, V vertexA, V vertexB, Edge originalEdge1, Edge originalEdge2) {
        super(groupId, vertexA, vertexB);
        this.originalEdges = Pair.of((Object)originalEdge1, (Object)originalEdge2);
    }

    protected ConjugateEdgeImpl(ConjugateEdgeImpl<V> other, boolean deepCopy) {
        super(other, deepCopy);
        this.originalEdges = other.originalEdges.copy();
    }

    @Override
    public double getLengthKm() {
        LOGGER.warning("Length of conjugate is combination of underlying original geometries/lengths, collect those instead, negative infinity returned");
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public void setLengthKm(double lengthInKm) {
        LOGGER.warning("Length of conjugate is combination of underlying original geometries/lengths, set those instead");
    }

    @Override
    public LineString getGeometry() {
        LOGGER.warning("Geometry of conjugate is combination of underlying original geometries, collect those instead, null returned");
        return null;
    }

    @Override
    public void setGeometry(LineString geometry) {
        LOGGER.warning("Geometry of conjugate is combination of underlying original geometries, set those instead");
    }

    @Override
    public ConjugateEdgeImpl<V> shallowClone() {
        return new ConjugateEdgeImpl<V>(this, false);
    }

    @Override
    public ConjugateEdgeImpl<V> deepClone() {
        return new ConjugateEdgeImpl<V>(this, true);
    }

    public Pair<Edge, Edge> getOriginalEdges() {
        return this.originalEdges;
    }
}

