/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gap;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.gap.GapFunction;
import org.goplanit.gap.StopCriterion;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.reflection.ReflectionUtils;

public class NormBasedGapFunction
extends GapFunction {
    private static final long serialVersionUID = 6739949628577467878L;
    private static final Logger LOGGER = Logger.getLogger(NormBasedGapFunction.class.getCanonicalName());
    protected int norm;
    protected boolean averaged;
    protected double measuredValue = 0.0;
    protected double count = 0.0;
    protected double gap = Double.POSITIVE_INFINITY;
    public static final double MAX_GAP = Double.POSITIVE_INFINITY;
    public static final int DEFAULT_NORM = 1;
    public static final boolean DEFAULT_AVERAGED = true;

    public NormBasedGapFunction(IdGroupingToken idToken, StopCriterion stopCriterion) {
        this(idToken, stopCriterion, 1, true);
    }

    public NormBasedGapFunction(IdGroupingToken idToken, StopCriterion stopCriterion, int norm) {
        this(idToken, stopCriterion, norm, true);
    }

    public NormBasedGapFunction(IdGroupingToken idToken, StopCriterion stopCriterion, int norm, boolean averaged) {
        super(idToken, stopCriterion);
        if (norm < 1) {
            LOGGER.warning(String.format("Invalid norm, reset to default %d", norm));
            this.norm = 1;
        } else {
            this.norm = norm;
        }
        this.averaged = averaged;
    }

    public NormBasedGapFunction(NormBasedGapFunction other, boolean deepCopy) {
        super(other, deepCopy);
        this.averaged = other.averaged;
        this.count = other.count;
        this.gap = other.gap;
        this.measuredValue = other.measuredValue;
        this.norm = other.norm;
    }

    public double getMeasuredValue() {
        return this.measuredValue;
    }

    public void increaseMeasuredValue(double[] vector1, double[] vector2) {
        if (vector1.length != vector2.length) {
            LOGGER.warning("Cannot compute increasedMEaseredValue of NormBasedGapFunction for two vectors when they are of different size");
            return;
        }
        int length = vector1.length;
        for (int index = 0; index < length; ++index) {
            if (this.norm == 1) {
                this.measuredValue += Math.abs(vector1[index] - vector2[index]);
                continue;
            }
            this.measuredValue += Math.pow(vector1[index] - vector2[index], this.norm);
        }
        this.count += (double)length;
    }

    public void increaseMeasuredValue(double value1, double value2) {
        this.measuredValue = this.norm == 1 ? (this.measuredValue += Math.abs(value1 - value2)) : (this.measuredValue += Math.pow(value1 - value2, this.norm));
        this.count += 1.0;
    }

    @Override
    public void reset() {
        this.measuredValue = 0.0;
        this.count = 0.0;
        this.gap = Double.POSITIVE_INFINITY;
    }

    @Override
    public double computeGap() {
        if (this.count <= 0.0) {
            this.gap = Double.POSITIVE_INFINITY;
        } else {
            double multiplicationFactor = this.isAveraged() ? 1.0 / this.count : 1.0;
            this.gap = multiplicationFactor * Math.pow(this.measuredValue, 1.0 / (double)this.norm);
        }
        return this.getGap();
    }

    @Override
    public double getGap() {
        return this.gap;
    }

    @Override
    public NormBasedGapFunction shallowClone() {
        return new NormBasedGapFunction(this, false);
    }

    @Override
    public NormBasedGapFunction deepClone() {
        return new NormBasedGapFunction(this, true);
    }

    @Override
    public Map<String, String> collectSettingsAsKeyValueMap() {
        HashMap<String, String> keyValueMap = new HashMap<String, String>(super.collectSettingsAsKeyValueMap());
        Map privateFieldNameValues = ReflectionUtils.declaredFieldsNameValueMap((Object)this, i -> Modifier.isProtected(i) && !Modifier.isStatic(i));
        privateFieldNameValues.forEach((k, v) -> keyValueMap.put((String)k, v.toString()));
        return keyValueMap;
    }

    public int getNorm() {
        return this.norm;
    }

    public void setNorm(int norm) {
        if (this.measuredValue > 0.0) {
            LOGGER.warning("IGNORED: Not allowed to change the norm while computing a gap, reset() first");
            return;
        }
        this.norm = norm;
    }

    public boolean isAveraged() {
        return this.averaged;
    }

    public void setAveraged(boolean averaged) {
        if (this.measuredValue > 0.0) {
            LOGGER.warning("IGNORED: Not allowed to change the averaging scheme while computing a gap, reset() first");
            return;
        }
        this.averaged = averaged;
    }
}

