/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gap;

import java.util.logging.Logger;
import org.goplanit.gap.GapFunction;
import org.goplanit.gap.StopCriterion;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.math.Precision;

public class LinkBasedRelativeDualityGapFunction
extends GapFunction {
    private static final long serialVersionUID = 7202275902172315983L;
    private static final Logger LOGGER = Logger.getLogger(LinkBasedRelativeDualityGapFunction.class.getCanonicalName());
    protected double measuredNetworkCost = 0.0;
    protected double minimumNetworkCost = 0.0;
    protected double gap = INITIAL_GAP;
    public static double INITIAL_GAP = Double.POSITIVE_INFINITY;

    public LinkBasedRelativeDualityGapFunction(IdGroupingToken idToken, StopCriterion stopCriterion) {
        super(idToken, stopCriterion);
    }

    public LinkBasedRelativeDualityGapFunction(LinkBasedRelativeDualityGapFunction other, boolean deepCopy) {
        super(other, deepCopy);
        this.measuredNetworkCost = other.measuredNetworkCost;
        this.gap = other.gap;
        this.minimumNetworkCost = other.minimumNetworkCost;
    }

    public double getMeasuredNetworkCost() {
        return this.measuredNetworkCost;
    }

    public void increaseMeasuredCost(double value) {
        this.measuredNetworkCost += value;
    }

    public void increaseConvexityBound(double value) {
        this.minimumNetworkCost += value;
    }

    @Override
    public void reset() {
        this.measuredNetworkCost = 0.0;
        this.minimumNetworkCost = 0.0;
        this.gap = INITIAL_GAP;
    }

    @Override
    public double computeGap() {
        double absoluteGap;
        if (Precision.smaller((double)this.measuredNetworkCost, (double)this.minimumNetworkCost)) {
            LOGGER.severe(String.format("Minimum network cost (%.2f) exceeds measured network cost (%.2f), this should not happen", this.minimumNetworkCost, this.measuredNetworkCost));
        }
        if ((absoluteGap = this.measuredNetworkCost - this.minimumNetworkCost) == 0.0) {
            this.gap = absoluteGap;
            return this.gap;
        }
        if (!Precision.positive((double)this.measuredNetworkCost)) {
            LOGGER.severe(String.format("Measured network cost (%.2f) needs to be positive to compute gap, this is not the case", this.measuredNetworkCost));
            return -1.0;
        }
        this.gap = absoluteGap / this.measuredNetworkCost;
        return this.gap;
    }

    @Override
    public double getGap() {
        return this.gap;
    }

    @Override
    public LinkBasedRelativeDualityGapFunction shallowClone() {
        return new LinkBasedRelativeDualityGapFunction(this, false);
    }

    @Override
    public LinkBasedRelativeDualityGapFunction deepClone() {
        return new LinkBasedRelativeDualityGapFunction(this, true);
    }
}

