/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gap;

import java.io.Serializable;
import java.util.Map;
import org.goplanit.component.PlanitComponent;
import org.goplanit.gap.LinkBasedRelativeDualityGapFunction;
import org.goplanit.gap.NormBasedGapFunction;
import org.goplanit.gap.StopCriterion;
import org.goplanit.utils.id.IdGroupingToken;

public abstract class GapFunction
extends PlanitComponent<GapFunction>
implements Serializable {
    private static final long serialVersionUID = -4378123200826871747L;
    protected final StopCriterion stopCriterion;
    public static final String LINK_BASED_RELATIVE_GAP = LinkBasedRelativeDualityGapFunction.class.getCanonicalName();
    public static final String NORM_BASED_GAP = NormBasedGapFunction.class.getCanonicalName();

    public GapFunction(IdGroupingToken idToken, StopCriterion stopCriterion) {
        super(idToken, GapFunction.class);
        this.stopCriterion = stopCriterion;
    }

    public GapFunction(GapFunction other, boolean deepCopy) {
        super(other, deepCopy);
        this.stopCriterion = deepCopy ? other.stopCriterion.deepClone() : other.stopCriterion;
    }

    @Override
    public Map<String, String> collectSettingsAsKeyValueMap() {
        Map<String, String> stopCriterionSettings = this.getStopCriterion().collectSettingsAsKeyValueMap();
        return stopCriterionSettings;
    }

    public boolean hasConverged(int iterationIndex) {
        return this.stopCriterion.hasConverged(this.getGap(), iterationIndex);
    }

    public StopCriterion getStopCriterion() {
        return this.stopCriterion;
    }

    public abstract double computeGap();

    public abstract double getGap();

    @Override
    public abstract void reset();

    public abstract GapFunction shallowClone();

    public abstract GapFunction deepClone();
}

