/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.event.handler;

import java.util.Arrays;
import java.util.logging.Logger;
import org.goplanit.demands.modifier.event.DemandsModificationEvent;
import org.goplanit.demands.modifier.event.DemandsModifierListener;
import org.goplanit.utils.event.Event;
import org.goplanit.utils.event.EventType;
import org.goplanit.utils.graph.modifier.event.DirectedGraphModificationEvent;
import org.goplanit.utils.graph.modifier.event.DirectedGraphModifierListener;
import org.goplanit.utils.graph.modifier.event.GraphModificationEvent;
import org.goplanit.utils.graph.modifier.event.GraphModifierListener;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.service.routed.modifier.RoutedServicesModificationEvent;
import org.goplanit.utils.service.routed.modifier.RoutedServicesModifierListener;

public abstract class SyncXmlIdToIdHandler
implements RoutedServicesModifierListener,
GraphModifierListener,
DirectedGraphModifierListener,
DemandsModifierListener {
    private static final Logger LOGGER = Logger.getLogger(SyncXmlIdToIdHandler.class.getCanonicalName());
    private final EventType[] eventTypes;

    protected <T extends ExternalIdAble> void syncXmlIdToInternalId(T entity) {
        entity.setXmlId(String.valueOf(entity.getId()));
    }

    protected void onEvent(Event event) {
        if (!Arrays.stream(this.eventTypes).anyMatch(et -> et.equals((Object)event.getType()))) {
            LOGGER.warning(String.format("%s does not support event type %s", SyncXmlIdToIdHandler.class.getName(), event.getType()));
            return;
        }
    }

    public SyncXmlIdToIdHandler(EventType ... eventTypes) {
        this.eventTypes = eventTypes;
    }

    public EventType[] getKnownSupportedEventTypes() {
        return this.eventTypes;
    }

    public void onRoutedServicesModifierEvent(RoutedServicesModificationEvent event) {
        this.onEvent((Event)event);
    }

    public void onGraphModificationEvent(GraphModificationEvent event) {
        this.onEvent((Event)event);
    }

    public void onDirectedGraphModificationEvent(DirectedGraphModificationEvent event) {
        this.onEvent((Event)event);
    }

    @Override
    public void onDemandsModificationEvent(DemandsModificationEvent event) {
        this.onEvent(event);
    }
}

