/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.demands;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Logger;
import org.goplanit.component.PlanitComponent;
import org.goplanit.demands.TimePeriods;
import org.goplanit.demands.TravellerTypes;
import org.goplanit.demands.UserClasses;
import org.goplanit.demands.modifier.DemandsModifier;
import org.goplanit.od.demand.OdDemands;
import org.goplanit.userclass.TravellerType;
import org.goplanit.userclass.UserClass;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.ManagedIdDeepCopyMapper;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.time.TimePeriod;

public class Demands
extends PlanitComponent<Demands>
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(Demands.class.getCanonicalName());
    private static final long serialVersionUID = 144798248371260732L;
    protected final TreeMap<Long, TreeMap<Mode, OdDemands>> odDemandsByTimePeriodAndMode;
    public final TimePeriods timePeriods;
    public final UserClasses userClasses;
    public final TravellerTypes travelerTypes;
    public final DemandsModifier demandModifier;

    public Demands(IdGroupingToken groupId) {
        super(groupId, Demands.class);
        this.travelerTypes = new TravellerTypes(groupId);
        this.userClasses = new UserClasses(groupId);
        this.timePeriods = new TimePeriods(groupId);
        this.odDemandsByTimePeriodAndMode = new TreeMap();
        this.demandModifier = new DemandsModifier(this);
    }

    public Demands(Demands other, boolean deepCopy) {
        super(other, deepCopy);
        this.odDemandsByTimePeriodAndMode = new TreeMap();
        if (deepCopy) {
            ManagedIdDeepCopyMapper travellerTypesMapper = new ManagedIdDeepCopyMapper();
            ManagedIdDeepCopyMapper userClassesMapper = new ManagedIdDeepCopyMapper();
            ManagedIdDeepCopyMapper timePeriodMapper = new ManagedIdDeepCopyMapper();
            this.travelerTypes = other.travelerTypes.deepCloneWithMapping((BiConsumer)travellerTypesMapper);
            this.userClasses = other.userClasses.deepCloneWithMapping((BiConsumer)userClassesMapper);
            this.timePeriods = other.timePeriods.deepCloneWithMapping((BiConsumer)timePeriodMapper);
            this.updateUserClassTravellerTypes(t -> (TravellerType)((Object)((Object)travellerTypesMapper.getMapping((Object)t))), true);
            Iterator iterator = this.timePeriods.iterator();
            while (iterator.hasNext()) {
                TimePeriod timePeriod = (TimePeriod)iterator.next();
                Set<Mode> modes = other.getRegisteredModesForTimePeriod(timePeriod);
                for (Mode mode : modes) {
                    OdDemands odDemandMatrix = other.get(mode, timePeriod);
                    TimePeriod clonedTimePeriod = (TimePeriod)timePeriodMapper.getMapping((Object)timePeriod);
                    if (clonedTimePeriod == null) {
                        throw new PlanItRunTimeException("Unable to find cloned time period, this shouldn't happen");
                    }
                    this.registerOdDemandPcuHour(clonedTimePeriod, mode, odDemandMatrix.deepClone());
                }
            }
        } else {
            this.travelerTypes = other.travelerTypes.shallowClone();
            this.userClasses = other.userClasses.shallowClone();
            this.timePeriods = other.timePeriods.shallowClone();
            this.odDemandsByTimePeriodAndMode.putAll(other.odDemandsByTimePeriodAndMode);
        }
        this.demandModifier = new DemandsModifier(this);
    }

    public void updateUserClassTravellerTypes(Function<TravellerType, TravellerType> ttToTtMapping, boolean removeMissingMappings) {
        Iterator iterator = this.userClasses.iterator();
        while (iterator.hasNext()) {
            UserClass userClass = (UserClass)((Object)iterator.next());
            TravellerType travellerType = userClass.getTravelerType();
            TravellerType newTravellerType = ttToTtMapping.apply(travellerType);
            if (newTravellerType == null && !removeMissingMappings) continue;
            userClass.setTravellerType(newTravellerType);
        }
    }

    public OdDemands registerOdDemandPcuHour(TimePeriod timePeriod, Mode mode, OdDemands odDemandsPcuHour) {
        if (!this.odDemandsByTimePeriodAndMode.containsKey(timePeriod.getId())) {
            this.odDemandsByTimePeriodAndMode.put(timePeriod.getId(), new TreeMap());
        }
        return this.odDemandsByTimePeriodAndMode.get(timePeriod.getId()).put(mode, odDemandsPcuHour);
    }

    public OdDemands get(Mode mode, TimePeriod timePeriod) {
        if (this.odDemandsByTimePeriodAndMode.containsKey(timePeriod.getId()) && this.odDemandsByTimePeriodAndMode.get(timePeriod.getId()).containsKey(mode)) {
            return this.odDemandsByTimePeriodAndMode.get(timePeriod.getId()).get(mode);
        }
        return null;
    }

    public Set<Mode> getRegisteredModesForTimePeriod(TimePeriod timePeriod) {
        if (this.odDemandsByTimePeriodAndMode.containsKey(timePeriod.getId())) {
            return this.odDemandsByTimePeriodAndMode.get(timePeriod.getId()).keySet();
        }
        return null;
    }

    public Demands shallowClone() {
        return new Demands(this, false);
    }

    public Demands deepClone() {
        return new Demands(this, true);
    }

    public void logInfo(String prefix) {
        LOGGER.info(String.format("%s#time periods: %d", prefix, this.timePeriods.size()));
        LOGGER.info(String.format("%s#user classes: %d", prefix, this.userClasses.size()));
        LOGGER.info(String.format("%s#traveller types: %d", prefix, this.travelerTypes.size()));
        this.odDemandsByTimePeriodAndMode.entrySet().forEach(tpEntry -> LOGGER.info(String.format("%s#Oddemands by mode for time period %s: %d", prefix, ((TimePeriod)this.timePeriods.get((Long)tpEntry.getKey())).getDescription(), ((TreeMap)tpEntry.getValue()).entrySet().size())));
    }

    @Override
    public void reset() {
        this.travelerTypes.clear();
        this.userClasses.clear();
        this.timePeriods.clear();
        this.odDemandsByTimePeriodAndMode.clear();
    }

    public DemandsModifier getDemandsModifier() {
        return this.demandModifier;
    }

    @Override
    public Map<String, String> collectSettingsAsKeyValueMap() {
        return null;
    }
}

