/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.cost.virtual;

import java.util.HashMap;
import java.util.Map;
import org.goplanit.cost.virtual.AbstractVirtualCost;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.virtual.ConnectoidSegment;
import org.goplanit.utils.network.virtual.VirtualNetwork;
import org.goplanit.utils.time.TimePeriod;

public class SpeedConnectoidTravelTimeCost
extends AbstractVirtualCost {
    private static final long serialVersionUID = 2813935702895030693L;
    public static final double DEFAULT_CONNECTOID_SPEED_KPH = 25.0;
    private double connectoidSpeed;

    public SpeedConnectoidTravelTimeCost(IdGroupingToken groupId) {
        super(groupId);
        this.connectoidSpeed = 25.0;
    }

    public SpeedConnectoidTravelTimeCost(SpeedConnectoidTravelTimeCost other, boolean deepCopy) {
        super(other, deepCopy);
        this.connectoidSpeed = other.connectoidSpeed;
    }

    public void setConnectoidSpeed(double connectoidSpeed) {
        this.connectoidSpeed = connectoidSpeed;
    }

    @Override
    public void initialiseBeforeSimulation(VirtualNetwork virtualNetwork) throws PlanItException {
    }

    @Override
    public void updateTimePeriod(TimePeriod timePeriod) {
    }

    @Override
    public double getGeneralisedCost(Mode mode, ConnectoidSegment connectoidSegment) {
        return connectoidSegment.getParent().getLengthKm() / this.connectoidSpeed;
    }

    @Override
    public void populateWithCost(VirtualNetwork virtualNetwork, Mode mode, double[] costToFill) throws PlanItException {
        for (ConnectoidSegment virtualSegment : virtualNetwork.getConnectoidSegments()) {
            costToFill[(int)virtualSegment.getId()] = this.getGeneralisedCost(mode, virtualSegment);
        }
    }

    public SpeedConnectoidTravelTimeCost shallowClone() {
        return new SpeedConnectoidTravelTimeCost(this, false);
    }

    public SpeedConnectoidTravelTimeCost deepClone() {
        return new SpeedConnectoidTravelTimeCost(this, true);
    }

    @Override
    public void reset() {
    }

    @Override
    public double getTravelTimeCost(Mode mode, ConnectoidSegment connectoidSegment) {
        return this.getGeneralisedCost(mode, connectoidSegment);
    }

    @Override
    public double getDTravelTimeDFlow(boolean uncongested, Mode mode, ConnectoidSegment connectoidSegment) {
        return 0.0;
    }

    @Override
    public Map<String, String> collectSettingsAsKeyValueMap() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("fixed-speed-connectoid-cost (km/h)", "" + this.connectoidSpeed);
        return settings;
    }
}

