/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.cost.virtual;

import java.util.HashMap;
import java.util.Map;
import org.goplanit.cost.virtual.AbstractVirtualCost;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.virtual.ConnectoidSegment;
import org.goplanit.utils.network.virtual.VirtualNetwork;
import org.goplanit.utils.time.TimePeriod;

public class FixedConnectoidTravelTimeCost
extends AbstractVirtualCost {
    private static final long serialVersionUID = 4907231205390412202L;
    protected double fixedConnectoidCost = 0.0;
    public static final double DEFAULT_FIXED_COST = 0.0;

    public FixedConnectoidTravelTimeCost(IdGroupingToken groupId) {
        super(groupId);
    }

    public FixedConnectoidTravelTimeCost(FixedConnectoidTravelTimeCost other, boolean deepCopy) {
        super(other, deepCopy);
        this.fixedConnectoidCost = other.fixedConnectoidCost;
    }

    public void setFixedConnectoidCost(double fixedConnectoidCost) {
        this.fixedConnectoidCost = fixedConnectoidCost;
    }

    @Override
    public void initialiseBeforeSimulation(VirtualNetwork virtualNetwork) throws PlanItException {
    }

    @Override
    public void updateTimePeriod(TimePeriod timePeriod) {
    }

    @Override
    public double getGeneralisedCost(Mode mode, ConnectoidSegment connectoidSegment) {
        return this.fixedConnectoidCost;
    }

    @Override
    public void populateWithCost(VirtualNetwork virtualNetwork, Mode mode, double[] costToFill) {
        for (ConnectoidSegment virtualSegment : virtualNetwork.getConnectoidSegments()) {
            costToFill[(int)virtualSegment.getId()] = this.fixedConnectoidCost;
        }
    }

    public FixedConnectoidTravelTimeCost shallowClone() {
        return new FixedConnectoidTravelTimeCost(this, false);
    }

    public FixedConnectoidTravelTimeCost deepClone() {
        return new FixedConnectoidTravelTimeCost(this, true);
    }

    @Override
    public void reset() {
    }

    @Override
    public double getTravelTimeCost(Mode mode, ConnectoidSegment connectoidSegment) {
        return this.getGeneralisedCost(mode, connectoidSegment);
    }

    @Override
    public double getDTravelTimeDFlow(boolean uncongested, Mode mode, ConnectoidSegment connectoidSegment) {
        return 0.0;
    }

    @Override
    public Map<String, String> collectSettingsAsKeyValueMap() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("Fixed-connectoid-cost (h)", "" + this.fixedConnectoidCost);
        return settings;
    }
}

