/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.cost.physical.initial;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.cost.Cost;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;

public class InitialModesLinkSegmentCost
implements Cost<MacroscopicLinkSegment> {
    private static final Logger LOGGER = Logger.getLogger(InitialModesLinkSegmentCost.class.getCanonicalName());
    protected final Map<Mode, Map<Long, Double>> costPerModeAndLinkSegment = new HashMap<Mode, Map<Long, Double>>();

    protected InitialModesLinkSegmentCost() {
    }

    protected InitialModesLinkSegmentCost(InitialModesLinkSegmentCost initialLinkSegmentCostMode) {
        this();
        initialLinkSegmentCostMode.costPerModeAndLinkSegment.forEach((mode, map) -> this.costPerModeAndLinkSegment.put((Mode)mode, new HashMap(map)));
    }

    public boolean isSegmentCostsSetForMode(Mode mode) {
        return this.costPerModeAndLinkSegment.containsKey(mode);
    }

    @Override
    public double getGeneralisedCost(Mode mode, MacroscopicLinkSegment linkSegment) {
        Map<Long, Double> costPerLinkSegment = this.costPerModeAndLinkSegment.get(mode);
        if (costPerLinkSegment == null) {
            return Double.POSITIVE_INFINITY;
        }
        Double foundCost = costPerLinkSegment.get(linkSegment.getId());
        if (foundCost == null) {
            return Double.POSITIVE_INFINITY;
        }
        return foundCost;
    }

    public void setSegmentCost(Mode mode, MacroscopicLinkSegment linkSegment, double cost) {
        if (!this.costPerModeAndLinkSegment.containsKey(mode)) {
            this.costPerModeAndLinkSegment.put(mode, new HashMap());
        }
        this.costPerModeAndLinkSegment.get(mode).put(linkSegment.getId(), cost);
    }

    public void setSegmentCost(Mode mode, long linkSegmentId, double cost) {
        if (!this.costPerModeAndLinkSegment.containsKey(mode)) {
            this.costPerModeAndLinkSegment.put(mode, new HashMap());
        }
        this.costPerModeAndLinkSegment.get(mode).put(linkSegmentId, cost);
    }

    public InitialModesLinkSegmentCost shallowClone() {
        return new InitialModesLinkSegmentCost(this);
    }

    public void reset() {
        this.costPerModeAndLinkSegment.clear();
    }

    @Override
    public double getTravelTimeCost(Mode mode, MacroscopicLinkSegment linkSegment) {
        return this.getGeneralisedCost(mode, linkSegment);
    }

    @Override
    public double getDTravelTimeDFlow(boolean uncongested, Mode mode, MacroscopicLinkSegment linkSegment) {
        LOGGER.severe("Initial (modes) cost has no derivative, unable to compute");
        return Double.NEGATIVE_INFINITY;
    }
}

