/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.cost.physical;

import org.goplanit.cost.physical.AbstractPhysicalCost;
import org.goplanit.cost.physical.BPRConfigurator;
import org.goplanit.cost.physical.FreeFlowLinkTravelTimeConfigurator;
import org.goplanit.cost.physical.PhysicalCost;
import org.goplanit.cost.physical.PhysicalCostConfigurator;
import org.goplanit.cost.physical.SteadyStateTravelTimeConfigurator;
import org.goplanit.utils.exceptions.PlanItException;

public class PhysicalCostConfiguratorFactory {
    public static PhysicalCostConfigurator<? extends AbstractPhysicalCost> createConfigurator(String physicalCostType) throws PlanItException {
        if (physicalCostType.equals(PhysicalCost.BPR)) {
            return new BPRConfigurator();
        }
        if (physicalCostType.equals(PhysicalCost.FREEFLOW)) {
            return new FreeFlowLinkTravelTimeConfigurator();
        }
        if (physicalCostType.equals(PhysicalCost.STEADY_STATE)) {
            return new SteadyStateTravelTimeConfigurator();
        }
        throw new PlanItException(String.format("Unable to construct configurator for given PhysicalCostType %s", physicalCostType));
    }
}

