/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.cost.physical;

import java.util.Map;
import org.goplanit.cost.physical.AbstractPhysicalCost;
import org.goplanit.network.LayeredNetwork;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.time.TimePeriod;

public class FreeFlowLinkTravelTimeCost
extends AbstractPhysicalCost {
    private static final long serialVersionUID = 4465724624295866542L;

    public FreeFlowLinkTravelTimeCost(IdGroupingToken groupId) {
        super(groupId);
    }

    public FreeFlowLinkTravelTimeCost(FreeFlowLinkTravelTimeCost other, boolean deepCopy) {
        super(other, deepCopy);
    }

    @Override
    public void initialiseBeforeSimulation(LayeredNetwork<?, ?> network) throws PlanItException {
        PlanItException.throwIf((!(network instanceof MacroscopicNetwork) ? 1 : 0) != 0, (String)"Free flow  travel time cost is only compatible with macroscopic networks", (Object[])new Object[0]);
        MacroscopicNetwork macroscopicNetwork = (MacroscopicNetwork)network;
        PlanItException.throwIf((((MacroscopicNetworkLayers)macroscopicNetwork.getTransportLayers()).size() != 1 ? 1 : 0) != 0, (String)"Free flow travel time cost is currently only compatible with networks using a single infrastructure layer", (Object[])new Object[0]);
    }

    @Override
    public void updateTimePeriod(TimePeriod timePeriod) {
    }

    @Override
    public double getGeneralisedCost(Mode mode, MacroscopicLinkSegment linkSegment) {
        return linkSegment.computeFreeFlowTravelTimeHour(mode);
    }

    @Override
    public double getTravelTimeCost(Mode mode, MacroscopicLinkSegment linkSegment) {
        return this.getGeneralisedCost(mode, linkSegment);
    }

    @Override
    public double getDTravelTimeDFlow(boolean uncongested, Mode mode, MacroscopicLinkSegment linkSegment) {
        return 0.0;
    }

    public FreeFlowLinkTravelTimeCost shallowClone() {
        return new FreeFlowLinkTravelTimeCost(this, false);
    }

    public FreeFlowLinkTravelTimeCost deepClone() {
        return new FreeFlowLinkTravelTimeCost(this, true);
    }

    @Override
    public void reset() {
    }

    @Override
    public Map<String, String> collectSettingsAsKeyValueMap() {
        return null;
    }
}

