/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.cost.physical;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.cost.physical.AbstractPhysicalCost;
import org.goplanit.interactor.LinkVolumeAccessee;
import org.goplanit.interactor.LinkVolumeAccessor;
import org.goplanit.network.LayeredNetwork;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.physical.UntypedPhysicalLayer;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.time.TimePeriod;

public class BprLinkTravelTimeCost
extends AbstractPhysicalCost
implements LinkVolumeAccessor {
    private static final long serialVersionUID = -1529475107840907959L;
    private static final Logger LOGGER = Logger.getLogger(BprLinkTravelTimeCost.class.getCanonicalName());
    protected LinkVolumeAccessee linkVolumeAccessee = null;
    protected Pair<Double, Double> defaultParameters;
    protected BprParameters defaultParametersPerMode;
    protected Map<MacroscopicLinkSegmentType, BprParameters> defaultParametersPerLinkSegmentTypeAndMode;
    protected Map<MacroscopicLinkSegment, BprParameters> parametersPerLinkSegmentAndMode;
    protected BprParameters[] bprParametersPerLinkSegment = null;
    protected double[][] freeFlowTravelTimePerLinkSegment = null;
    public static final double DEFAULT_ALPHA = 0.5;
    public static final double DEFAULT_BETA = 4.0;

    protected double computeCostInHours(MacroscopicLinkSegment linkSegment, Mode mode, double flowPcuPerHour) {
        if (!linkSegment.isModeAllowed(mode)) {
            return Double.MAX_VALUE;
        }
        int id = (int)linkSegment.getId();
        double freeFlowTravelTime = this.freeFlowTravelTimePerLinkSegment[(int)mode.getId()][id];
        double capacity = linkSegment.getCapacityOrDefaultPcuH();
        Pair<Double, Double> alphaBetaParameters = this.bprParametersPerLinkSegment[id].getAlphaBetaParameters(mode);
        double alpha = (Double)alphaBetaParameters.first();
        double beta = (Double)alphaBetaParameters.second();
        return freeFlowTravelTime * (1.0 + alpha * Math.pow(flowPcuPerHour / capacity, beta));
    }

    public BprLinkTravelTimeCost(IdGroupingToken groupId) {
        super(groupId);
        this.parametersPerLinkSegmentAndMode = new HashMap<MacroscopicLinkSegment, BprParameters>();
        this.defaultParametersPerMode = new BprParameters();
        this.defaultParametersPerLinkSegmentTypeAndMode = new HashMap<MacroscopicLinkSegmentType, BprParameters>();
        this.defaultParameters = Pair.of((Object)0.5, (Object)4.0);
    }

    public BprLinkTravelTimeCost(BprLinkTravelTimeCost other, boolean deepCopy) {
        super(other, deepCopy);
        int index;
        this.linkVolumeAccessee = other.linkVolumeAccessee;
        this.parametersPerLinkSegmentAndMode = new HashMap<MacroscopicLinkSegment, BprParameters>();
        other.parametersPerLinkSegmentAndMode.forEach((k, v) -> this.parametersPerLinkSegmentAndMode.put((MacroscopicLinkSegment)k, v.copy()));
        this.defaultParametersPerMode = other.defaultParametersPerMode.copy();
        this.defaultParametersPerLinkSegmentTypeAndMode = new HashMap<MacroscopicLinkSegmentType, BprParameters>();
        other.defaultParametersPerLinkSegmentTypeAndMode.forEach((k, v) -> this.defaultParametersPerLinkSegmentTypeAndMode.put((MacroscopicLinkSegmentType)k, v.copy()));
        this.defaultParameters = other.defaultParameters.copy();
        this.bprParametersPerLinkSegment = new BprParameters[other.bprParametersPerLinkSegment.length];
        for (index = 0; index < this.bprParametersPerLinkSegment.length; ++index) {
            this.bprParametersPerLinkSegment[index] = other.bprParametersPerLinkSegment[index].copy();
        }
        this.freeFlowTravelTimePerLinkSegment = new double[other.freeFlowTravelTimePerLinkSegment.length][other.freeFlowTravelTimePerLinkSegment[0].length];
        for (index = 0; index < this.bprParametersPerLinkSegment.length; ++index) {
            this.freeFlowTravelTimePerLinkSegment[index] = Arrays.copyOf(other.freeFlowTravelTimePerLinkSegment[index], other.freeFlowTravelTimePerLinkSegment[index].length);
        }
    }

    public void setParameters(MacroscopicLinkSegment linkSegment, Mode mode, double alpha, double beta) {
        if (this.parametersPerLinkSegmentAndMode.get(linkSegment) == null) {
            this.parametersPerLinkSegmentAndMode.put(linkSegment, new BprParameters());
        }
        this.parametersPerLinkSegmentAndMode.get(linkSegment).registerParameters(mode, alpha, beta);
    }

    public void setDefaultParameters(Mode mode, double alpha, double beta) {
        this.defaultParametersPerMode.registerParameters(mode, alpha, beta);
    }

    public void setDefaultParameters(MacroscopicLinkSegmentType macroscopicLinkSegmentType, Mode mode, double alpha, double beta) {
        if (this.defaultParametersPerLinkSegmentTypeAndMode.get(macroscopicLinkSegmentType) == null) {
            this.defaultParametersPerLinkSegmentTypeAndMode.put(macroscopicLinkSegmentType, new BprParameters());
        }
        this.defaultParametersPerLinkSegmentTypeAndMode.get(macroscopicLinkSegmentType).registerParameters(mode, alpha, beta);
    }

    public void setDefaultParameters(double alpha, double beta) {
        this.defaultParameters = Pair.of((Object)alpha, (Object)beta);
    }

    @Override
    public void initialiseBeforeSimulation(LayeredNetwork<?, ?> network) throws PlanItException {
        PlanItException.throwIf((!(network instanceof MacroscopicNetwork) ? 1 : 0) != 0, (String)"BPR cost is only compatible with macroscopic networks", (Object[])new Object[0]);
        MacroscopicNetwork macroscopicNetwork = (MacroscopicNetwork)network;
        PlanItException.throwIf((((MacroscopicNetworkLayers)macroscopicNetwork.getTransportLayers()).size() != 1 ? 1 : 0) != 0, (String)"BPR cost is currently only compatible with networks using a single infrastructure layer", (Object[])new Object[0]);
        MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)((MacroscopicNetworkLayers)macroscopicNetwork.getTransportLayers()).getFirst();
        if (network.getModes().size() != networkLayer.getSupportedModes().size()) {
            LOGGER.warning("network wide modes do not match modes supported by only layer, this makes the assignment less efficient, consider removing unused modes");
        }
        this.freeFlowTravelTimePerLinkSegment = new double[network.getModes().size()][networkLayer.getLinkSegments().size()];
        for (Mode mode : network.getModes()) {
            this.freeFlowTravelTimePerLinkSegment[(int)mode.getId()] = networkLayer.getLinkSegments().getFreeFlowTravelTimeHourPerLinkSegment(mode);
        }
        this.bprParametersPerLinkSegment = new BprParameters[networkLayer.getLinkSegments().size()];
        for (MacroscopicLinkSegment macroscopicLinkSegment : networkLayer.getLinkSegments()) {
            int id = (int)macroscopicLinkSegment.getLinkSegmentId();
            this.bprParametersPerLinkSegment[id] = new BprParameters();
            MacroscopicLinkSegmentType macroscopicLinkSegmentType = macroscopicLinkSegment.getLinkSegmentType();
            for (Mode mode : network.getModes()) {
                Pair<Double, Double> alphaBetaPair = this.parametersPerLinkSegmentAndMode.get(macroscopicLinkSegment) != null && this.parametersPerLinkSegmentAndMode.get(macroscopicLinkSegment).getAlphaBetaParameters(mode) != null ? this.parametersPerLinkSegmentAndMode.get(macroscopicLinkSegment).getAlphaBetaParameters(mode) : (this.defaultParametersPerLinkSegmentTypeAndMode.get(macroscopicLinkSegmentType) != null && this.defaultParametersPerLinkSegmentTypeAndMode.get(macroscopicLinkSegmentType).getAlphaBetaParameters(mode) != null ? this.defaultParametersPerLinkSegmentTypeAndMode.get(macroscopicLinkSegmentType).getAlphaBetaParameters(mode) : (this.defaultParametersPerMode.getAlphaBetaParameters(mode) != null ? this.defaultParametersPerMode.getAlphaBetaParameters(mode) : this.defaultParameters));
                this.bprParametersPerLinkSegment[id].registerParameters(mode, alphaBetaPair);
            }
        }
    }

    @Override
    public void updateTimePeriod(TimePeriod timePeriod) {
    }

    @Override
    public double getGeneralisedCost(Mode mode, MacroscopicLinkSegment linkSegment) {
        return this.computeCostInHours(linkSegment, mode, this.linkVolumeAccessee.getLinkSegmentVolume((LinkSegment)linkSegment));
    }

    @Override
    public double getTravelTimeCost(Mode mode, MacroscopicLinkSegment linkSegment) {
        return this.computeCostInHours(linkSegment, mode, this.linkVolumeAccessee.getLinkSegmentVolume((LinkSegment)linkSegment));
    }

    @Override
    public double getDTravelTimeDFlow(boolean uncongested, Mode mode, MacroscopicLinkSegment linkSegment) {
        if (!linkSegment.isModeAllowed(mode)) {
            return Double.MAX_VALUE;
        }
        int id = (int)linkSegment.getId();
        double freeFlowTravelTime = this.freeFlowTravelTimePerLinkSegment[(int)mode.getId()][id];
        double capacity = linkSegment.getCapacityOrDefaultPcuH();
        Pair<Double, Double> alphaBetaParameters = this.bprParametersPerLinkSegment[id].getAlphaBetaParameters(mode);
        double alpha = (Double)alphaBetaParameters.first();
        double beta = (Double)alphaBetaParameters.second();
        double currentFlow = this.linkVolumeAccessee.getLinkSegmentVolume((LinkSegment)linkSegment);
        return (beta - 1.0) * freeFlowTravelTime * alpha * Math.pow(currentFlow / capacity, beta - 1.0);
    }

    @Override
    public void populateWithCost(UntypedPhysicalLayer<?, ?, MacroscopicLinkSegment> physicalLayer, Mode mode, double[] costToFill) {
        double[] linkSegmentFlows = this.linkVolumeAccessee.getLinkSegmentVolumes();
        for (MacroscopicLinkSegment linkSegment : physicalLayer.getLinkSegments()) {
            int id = (int)linkSegment.getLinkSegmentId();
            costToFill[id] = this.computeCostInHours(linkSegment, mode, linkSegmentFlows[id]);
        }
    }

    @Override
    public void setAccessee(LinkVolumeAccessee linkVolumeAccessee) {
        this.linkVolumeAccessee = linkVolumeAccessee;
    }

    public BprLinkTravelTimeCost shallowClone() {
        return new BprLinkTravelTimeCost(this, false);
    }

    public BprLinkTravelTimeCost deepClone() {
        return new BprLinkTravelTimeCost(this, true);
    }

    @Override
    public void reset() {
        this.freeFlowTravelTimePerLinkSegment = null;
        this.bprParametersPerLinkSegment = null;
    }

    @Override
    public Map<String, String> collectSettingsAsKeyValueMap() {
        Pair<Double, Double> modeAlphaBeta;
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        keyValueMap.put("default-alpha/beta:", this.defaultParameters.first() + ", " + this.defaultParameters.second());
        for (Mode mode : this.defaultParametersPerMode.getModes()) {
            Pair<Double, Double> modeAlphaBeta2 = this.defaultParametersPerMode.getAlphaBetaParameters(mode);
            keyValueMap.put(mode.getName() + "-alpha/beta:", modeAlphaBeta2.first() + ", " + modeAlphaBeta2.second());
        }
        for (Map.Entry entry : this.defaultParametersPerLinkSegmentTypeAndMode.entrySet()) {
            BprParameters modesPerType = (BprParameters)entry.getValue();
            for (Mode modeEntry : modesPerType.getModes()) {
                modeAlphaBeta = modesPerType.getAlphaBetaParameters(modeEntry);
                keyValueMap.put("type-" + ((MacroscopicLinkSegmentType)entry.getKey()).getXmlId() + "-" + modeEntry.getName() + "-alpha/beta:", modeAlphaBeta.first() + ", " + modeAlphaBeta.second());
            }
        }
        for (Map.Entry entry : this.parametersPerLinkSegmentAndMode.entrySet()) {
            BprParameters modesPerSegment = (BprParameters)entry.getValue();
            for (Mode modeEntry : modesPerSegment.getModes()) {
                modeAlphaBeta = modesPerSegment.getAlphaBetaParameters(modeEntry);
                keyValueMap.put("segment-" + ((MacroscopicLinkSegment)entry.getKey()).getXmlId() + "-" + modeEntry.getName() + "-alpha/beta:", modeAlphaBeta.first() + ", " + modeAlphaBeta.second());
            }
        }
        return keyValueMap;
    }

    public class BprParameters {
        private final Map<Mode, Pair<Double, Double>> parametersMap;

        public BprParameters() {
            this.parametersMap = new HashMap<Mode, Pair<Double, Double>>();
        }

        public BprParameters(BprParameters other) {
            this.parametersMap = new HashMap<Mode, Pair<Double, Double>>(other.parametersMap);
        }

        private void registerParameters(Mode mode, double alpha, double beta) {
            if (beta < 1.0) {
                LOGGER.warning(String.format("BPR Beta parameter smaller than 1 (%.2f), unlikely choice", mode.getXmlId(), beta));
            }
            this.parametersMap.put(mode, (Pair<Double, Double>)Pair.of((Object)alpha, (Object)beta));
        }

        private void registerParameters(Mode mode, Pair<Double, Double> pair) {
            if ((Double)pair.second() < 1.0) {
                LOGGER.warning(String.format("BPR Beta parameter smaller than one (%.2f), unlikely choice", mode.getXmlId(), pair.second()));
            }
            this.parametersMap.put(mode, pair);
        }

        public Pair<Double, Double> getAlphaBetaParameters(Mode mode) {
            return this.parametersMap.get(mode);
        }

        public Set<Mode> getModes() {
            return this.parametersMap.keySet();
        }

        public BprParameters copy() {
            return new BprParameters(this);
        }
    }
}

