/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.cost.physical;

import java.io.Serializable;
import java.util.logging.Logger;
import org.goplanit.component.PlanitComponent;
import org.goplanit.cost.physical.PhysicalCost;
import org.goplanit.network.LayeredNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.physical.UntypedPhysicalLayer;
import org.goplanit.utils.time.TimePeriod;

public abstract class AbstractPhysicalCost
extends PlanitComponent<AbstractPhysicalCost>
implements PhysicalCost<MacroscopicLinkSegment>,
Serializable {
    private static final long serialVersionUID = 3657719270477537657L;
    private static final Logger LOGGER = Logger.getLogger(AbstractPhysicalCost.class.getCanonicalName());

    protected AbstractPhysicalCost(IdGroupingToken groupId) {
        super(groupId, AbstractPhysicalCost.class);
    }

    public AbstractPhysicalCost(AbstractPhysicalCost abstractPhysicalCost, boolean deepCopy) {
        super(abstractPhysicalCost, deepCopy);
    }

    public void populateWithCost(UntypedPhysicalLayer<?, ?, MacroscopicLinkSegment> physicalLayer, Mode mode, double[] costToFill) {
        if (physicalLayer.getLinkSegments().isEmpty()) {
            LOGGER.warning("No physical links segments found in provided network layer, unable to populate link segment costs");
        }
        for (MacroscopicLinkSegment linkSegment : physicalLayer.getLinkSegments()) {
            costToFill[(int)linkSegment.getId()] = this.getGeneralisedCost(mode, (EdgeSegment)linkSegment);
        }
    }

    public abstract void initialiseBeforeSimulation(LayeredNetwork<?, ?> var1) throws PlanItException;

    public abstract void updateTimePeriod(TimePeriod var1);
}

