/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.cost;

import java.util.logging.Logger;
import org.goplanit.cost.physical.AbstractPhysicalCost;
import org.goplanit.cost.virtual.VirtualCost;
import org.goplanit.network.UntypedPhysicalNetwork;
import org.goplanit.network.transport.TransportModelNetwork;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.physical.UntypedPhysicalLayer;
import org.goplanit.utils.network.virtual.ConnectoidSegment;
import org.goplanit.utils.network.virtual.VirtualNetwork;
import org.goplanit.zoning.Zoning;

public class CostUtils {
    private static final Logger LOGGER = Logger.getLogger(CostUtils.class.getCanonicalName());

    public static double[] createEmptyLinkSegmentCostArray(UntypedPhysicalNetwork network, Zoning zoning) {
        if (network.getTransportLayers().size() > 1) {
            throw new PlanItRunTimeException("Link segment cost array can only be created if physical network only has a single layer, multi-layer support has not yet been implemented");
        }
        return new double[TransportModelNetwork.getNumberOfEdgeSegmentsAllLayers(network, zoning)];
    }

    public static double[] createEmptyLinkSegmentCostArray(UntypedPhysicalNetwork network) {
        if (network.getTransportLayers().size() > 1) {
            throw new PlanItRunTimeException("Link segment cost array can only be created if physical network only has a single layer, multi-layer support has not yet been implemented");
        }
        return new double[TransportModelNetwork.getNumberOfPhysicalLinkSegmentsAllLayers(network)];
    }

    public static void populateModalVirtualLinkSegmentCosts(Mode mode, VirtualCost virtualCost, VirtualNetwork virtualNetwork, double[] costArray) {
        if (virtualNetwork.getConnectoidSegments().isEmpty()) {
            LOGGER.warning("No connectoid segments found in provided virtual network, unable to populate connectoid segment costs");
        }
        for (ConnectoidSegment currentSegment : virtualNetwork.getConnectoidSegments()) {
            costArray[(int)currentSegment.getId()] = virtualCost.getGeneralisedCost(mode, currentSegment);
        }
    }

    public static void populateModalPhysicalLinkSegmentCosts(Mode mode, AbstractPhysicalCost physicalCost, UntypedPhysicalNetwork network, double[] costArray) {
        physicalCost.populateWithCost((UntypedPhysicalLayer)network.getLayerByMode(mode), mode, costArray);
    }

    public static double[] createAndPopulateModalSegmentCost(Mode mode, AbstractPhysicalCost physicalCost, UntypedPhysicalNetwork network) {
        double[] segmentCosts = CostUtils.createEmptyLinkSegmentCostArray(network);
        CostUtils.populateModalPhysicalLinkSegmentCosts(mode, physicalCost, network, segmentCosts);
        return segmentCosts;
    }

    public static double[] createAndPopulateModalSegmentCost(Mode mode, VirtualCost virtualCost, AbstractPhysicalCost physicalCost, UntypedPhysicalNetwork network, Zoning zoning) {
        double[] segmentCosts = CostUtils.createEmptyLinkSegmentCostArray(network, zoning);
        CostUtils.populateModalVirtualLinkSegmentCosts(mode, virtualCost, zoning.getVirtualNetwork(), segmentCosts);
        CostUtils.populateModalPhysicalLinkSegmentCosts(mode, physicalCost, network, segmentCosts);
        return segmentCosts;
    }
}

