/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.converter.zoning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.goplanit.utils.exceptions.PlanItRunTimeException;
import org.goplanit.utils.geo.PlanitEntityGeoUtils;
import org.goplanit.utils.geo.PlanitGraphGeoUtils;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.directed.EdgeSegment;
import org.goplanit.utils.id.IdAble;
import org.goplanit.utils.locale.DrivingDirectionDefaultByCountry;
import org.goplanit.utils.misc.IterableUtils;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.TrackModeType;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLink;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.zoning.Zoning;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.linearref.LinearLocation;

public class ZoningConverterUtils {
    private static boolean isOverwriteActive(String waitingAreaSourceId, Node node, String accessLinkSourceId, Function<String, String> getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId, Function<Node, String> getOverwrittenWaitingAreaSourceId) {
        boolean isOverwriteActive = false;
        if (getOverwrittenWaitingAreaSourceId != null && getOverwrittenWaitingAreaSourceId.apply(node) != null) {
            boolean bl = isOverwriteActive = waitingAreaSourceId != getOverwrittenWaitingAreaSourceId.apply(node);
        }
        if (getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId != null && getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId.apply(waitingAreaSourceId) != null) {
            isOverwriteActive = isOverwriteActive || getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId.apply(waitingAreaSourceId).equals(accessLinkSourceId);
        }
        return isOverwriteActive;
    }

    public static boolean isWaitingAreaLeftOfAccessLineSegment(Geometry waitingAreaGeometry, MacroscopicLinkSegment accessLinkSegment, LineSegment accessLinkSegmentLineSegment, PlanitJtsCrsUtils geoUtils) {
        boolean reverseLinearLocationGeometry;
        LineSegment localLineSegment = new LineSegment(accessLinkSegmentLineSegment);
        boolean bl = reverseLinearLocationGeometry = accessLinkSegment.isDirectionAb() != accessLinkSegment.getParent().isGeometryInAbDirection();
        if (reverseLinearLocationGeometry) {
            localLineSegment.reverse();
        }
        return geoUtils.isGeometryLeftOf(waitingAreaGeometry, localLineSegment.p0, localLineSegment.p1);
    }

    @Deprecated
    private static boolean isWaitingAreaAccessLinkSegmentInternalLocationModeCombinationDirectionallyValid(String waitingAreaSourceId, Geometry waitingAreaGeometry, MacroscopicLink accessLink, Point connectoidLocation, Mode accessMode, Function<Point, String> getOverwrittenWaitingAreaSourceId, String countryName, PlanitJtsCrsUtils geoUtils) {
        boolean mustAvoidCrossingTraffic = ZoningConverterUtils.isAvoidCrossTrafficForAccessModeOrAccessNodeWaitingAreaOverwritten(accessMode, waitingAreaSourceId, connectoidLocation, getOverwrittenWaitingAreaSourceId);
        MacroscopicLinkSegment oneWayLinkSegment = accessLink.getLinkSegmentIfLinkIsOneWayForMode(accessMode);
        if (mustAvoidCrossingTraffic && oneWayLinkSegment != null) {
            boolean reverseLinearLocationGeometry;
            Coordinate[] linkCoordinates = accessLink.getGeometry().getCoordinates();
            int coordinateIndex = PlanitJtsUtils.getCoordinateIndexOf((Coordinate)connectoidLocation.getCoordinate(), (Coordinate[])linkCoordinates);
            if (coordinateIndex <= 0) {
                throw new PlanItRunTimeException("Unable to locate link internal location %s for access link even though it is expected to exist for waiting area %s", new Object[]{accessLink.getExternalId(), waitingAreaSourceId});
            }
            LineSegment segment = new LineSegment(linkCoordinates[coordinateIndex - 1], linkCoordinates[coordinateIndex]);
            boolean bl = reverseLinearLocationGeometry = oneWayLinkSegment.isDirectionAb() != oneWayLinkSegment.getParent().isGeometryInAbDirection();
            if (reverseLinearLocationGeometry) {
                segment.reverse();
            }
            return geoUtils.isGeometryLeftOf(waitingAreaGeometry, segment.p0, segment.p1) == DrivingDirectionDefaultByCountry.isLeftHandDrive((String)countryName);
        }
        return true;
    }

    public static <T> boolean isAvoidCrossTrafficForAccessModeOrAccessNodeWaitingAreaOverwritten(Mode accessMode, String waitingAreaSourceId, T accessEntity, Function<T, String> getOverwrittenWaitingAreaSourceId) {
        if (accessEntity != null && getOverwrittenWaitingAreaSourceId != null && getOverwrittenWaitingAreaSourceId.apply(accessEntity) != null) {
            return !waitingAreaSourceId.equals(getOverwrittenWaitingAreaSourceId.apply(accessEntity));
        }
        return ZoningConverterUtils.isAvoidCrossTrafficForAccessMode(accessMode);
    }

    public static boolean isAvoidCrossTrafficForAccessMode(Mode accessMode) {
        return accessMode.getPhysicalFeatures().getTrackType().equals((Object)TrackModeType.ROAD);
    }

    public static Collection<MacroscopicLink> excludeLinksOnWrongSideOf(Geometry location, Collection<MacroscopicLink> links, boolean isLeftHandDrive, Collection<? extends Mode> accessModes, PlanitJtsCrsUtils geoUtils) {
        HashSet<MacroscopicLink> matchedLinks = new HashSet<MacroscopicLink>(links);
        block0: for (MacroscopicLink link : links) {
            for (Mode mode : accessModes) {
                boolean mustAvoidCrossingTraffic = ZoningConverterUtils.isAvoidCrossTrafficForAccessMode(mode);
                MacroscopicLinkSegment oneWayLinkSegment = link.getLinkSegmentIfLinkIsOneWayForMode(mode);
                if (oneWayLinkSegment == null || !mustAvoidCrossingTraffic) continue;
                LineSegment finalLineSegment = PlanitEntityGeoUtils.extractClosestLineSegmentToGeometryFromLinkSegment((Geometry)location, (LinkSegment)oneWayLinkSegment, (PlanitJtsCrsUtils)geoUtils);
                boolean isStationLeftOfOneWayLinkSegment = geoUtils.isGeometryLeftOf(location, finalLineSegment.p0, finalLineSegment.p1);
                if (isStationLeftOfOneWayLinkSegment == isLeftHandDrive) continue;
                matchedLinks.remove(link);
                continue block0;
            }
        }
        return matchedLinks;
    }

    public static Collection<LinkSegment> identifyLinkSegmentsOnWrongSideOf(Geometry location, Collection<LinkSegment> accessLinkSegments, boolean leftHandDrive, PlanitJtsCrsUtils geoUtils) {
        ArrayList<LinkSegment> invalidAccessLinkSegments = new ArrayList<LinkSegment>(accessLinkSegments.size());
        for (LinkSegment linkSegment : accessLinkSegments) {
            LineSegment finalLineSegment = PlanitGraphGeoUtils.extractClosestLineSegmentTo((Geometry)location, (EdgeSegment)linkSegment, (PlanitJtsCrsUtils)geoUtils);
            boolean isTransferZoneLeftOfInfrastructure = geoUtils.isGeometryLeftOf(location, finalLineSegment.p0, finalLineSegment.p1);
            if (isTransferZoneLeftOfInfrastructure == leftHandDrive) continue;
            invalidAccessLinkSegments.add(linkSegment);
        }
        return invalidAccessLinkSegments;
    }

    public static Pair<MacroscopicLink, Boolean> excludeClosestLinksIncrementallyOnWrongSideOf(Geometry location, Collection<MacroscopicLink> links, boolean isLeftHandDrive, Collection<? extends Mode> accessModes, PlanitJtsCrsUtils geoUtils) {
        Collection<MacroscopicLink> result;
        boolean entriesRemoved = false;
        MacroscopicLink closestLink = null;
        while ((result = ZoningConverterUtils.excludeLinksOnWrongSideOf(location, Collections.singleton(closestLink = (MacroscopicLink)PlanitGraphGeoUtils.findEdgeClosest((Geometry)location, links, (PlanitJtsCrsUtils)geoUtils)), isLeftHandDrive, accessModes, geoUtils)) == null || result.isEmpty()) {
            links.remove(closestLink);
            entriesRemoved = true;
            closestLink = null;
            if (!links.isEmpty()) continue;
        }
        if (!links.isEmpty() && closestLink == null) {
            closestLink = (MacroscopicLink)PlanitGraphGeoUtils.findEdgeClosest((Geometry)location, links, (PlanitJtsCrsUtils)geoUtils);
        }
        return Pair.of((Object)closestLink, (Object)entriesRemoved);
    }

    public static Collection<? extends LinkSegment> findAccessLinkSegmentsForWaitingArea(String waitingAreaSourceId, Geometry waitingAreaGeometry, MacroscopicLink accessLink, String accessLinkSourceId, Mode accessMode, String countryName, boolean mustAvoidCrossingTraffic, Function<String, String> getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId, Function<Node, String> getOverwrittenWaitingAreaSourceId, PlanitJtsCrsUtils geoUtils) {
        Collection<LinkSegment> accessLinkSegments = ZoningConverterUtils.findAccessEntryLinkSegmentsForWaitingArea(waitingAreaSourceId, waitingAreaGeometry, accessLink, accessLinkSourceId, accessLink.getNodeA(), accessMode, countryName, mustAvoidCrossingTraffic, getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId, getOverwrittenWaitingAreaSourceId, geoUtils);
        Collection<LinkSegment> accessLinkSegmentsB = ZoningConverterUtils.findAccessEntryLinkSegmentsForWaitingArea(waitingAreaSourceId, waitingAreaGeometry, accessLink, accessLinkSourceId, accessLink.getNodeB(), accessMode, countryName, mustAvoidCrossingTraffic, getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId, getOverwrittenWaitingAreaSourceId, geoUtils);
        if (accessLinkSegments != null) {
            accessLinkSegments.addAll(accessLinkSegmentsB);
        } else {
            accessLinkSegments = accessLinkSegmentsB;
        }
        return accessLinkSegments;
    }

    public static Collection<LinkSegment> findAccessEntryLinkSegmentsForWaitingArea(String waitingAreaSourceId, Geometry waitingAreaGeometry, MacroscopicLink accessLink, String accessLinkSourceId, Node node, Mode accessMode, String countryName, boolean mustAvoidCrossingTraffic, Function<String, String> getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId, Function<Node, String> getOverwrittenWaitingAreaSourceId, PlanitJtsCrsUtils geoUtils) {
        boolean isLeftHandDrive;
        Collection<LinkSegment> toBeRemovedAccessLinkSegments;
        boolean removeInvalidAccessLinkSegmentsIfNoMatchLeft;
        ArrayList<LinkSegment> accessLinkSegments = new ArrayList<LinkSegment>(4);
        for (LinkSegment linkSegment : node.getEntryLinkSegments()) {
            if (!linkSegment.isModeAllowed(accessMode) || !linkSegment.getParent().idEquals((Object)accessLink)) continue;
            accessLinkSegments.add(linkSegment);
        }
        if (accessLinkSegments == null || accessLinkSegments.isEmpty()) {
            return accessLinkSegments;
        }
        boolean bl = removeInvalidAccessLinkSegmentsIfNoMatchLeft = !ZoningConverterUtils.isOverwriteActive(waitingAreaSourceId, node, accessLinkSourceId, getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId, getOverwrittenWaitingAreaSourceId);
        if (mustAvoidCrossingTraffic && !(toBeRemovedAccessLinkSegments = ZoningConverterUtils.identifyLinkSegmentsOnWrongSideOf(waitingAreaGeometry, accessLinkSegments, isLeftHandDrive = DrivingDirectionDefaultByCountry.isLeftHandDrive((String)countryName), geoUtils)).isEmpty() && (removeInvalidAccessLinkSegmentsIfNoMatchLeft || toBeRemovedAccessLinkSegments.size() < accessLinkSegments.size())) {
            accessLinkSegments.removeAll(toBeRemovedAccessLinkSegments);
        }
        return accessLinkSegments;
    }

    public static boolean isPotentialAccessEntryLinkSegmentForWaitingArea(String waitingAreaSourceId, Geometry waitingAreaGeometry, MacroscopicLinkSegment accessLinkSegment, String accessLinkSourceId, Node accessNode, Mode accessMode, Function<Node, String> getOverwrittenWaitingAreaSourceId, Function<String, String> getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId, String countryName, PlanitJtsCrsUtils geoUtils) {
        boolean removeInvalidAccessLinkSegment;
        boolean mustAvoidCrossingTraffic = ZoningConverterUtils.isAvoidCrossTrafficForAccessModeOrAccessNodeWaitingAreaOverwritten(accessMode, waitingAreaSourceId, accessNode, getOverwrittenWaitingAreaSourceId);
        boolean bl = removeInvalidAccessLinkSegment = !ZoningConverterUtils.isOverwriteActive(waitingAreaSourceId, accessLinkSegment.getDownstreamNode(), accessLinkSourceId, getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId, getOverwrittenWaitingAreaSourceId);
        if (!removeInvalidAccessLinkSegment) {
            return true;
        }
        if (mustAvoidCrossingTraffic) {
            boolean onWrongSide;
            boolean isLeftHandDrive = DrivingDirectionDefaultByCountry.isLeftHandDrive((String)countryName);
            boolean bl2 = onWrongSide = !ZoningConverterUtils.identifyLinkSegmentsOnWrongSideOf(waitingAreaGeometry, Collections.singleton(accessLinkSegment), isLeftHandDrive, geoUtils).isEmpty();
            if (onWrongSide) {
                return false;
            }
        }
        return true;
    }

    public static boolean hasWaitingAreaPotentialAccessLinkSegmentForLinkNodeModeCombination(String waitingAreaSourceId, Geometry waitingAreaGeometry, MacroscopicLink accessLink, String accessLinkSourceId, Node accessNode, Mode accessMode, Function<Node, String> getOverwrittenWaitingAreaSourceId, Function<String, String> getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId, String countryName, PlanitJtsCrsUtils geoUtils) {
        boolean mustAvoidCrossingTraffic = ZoningConverterUtils.isAvoidCrossTrafficForAccessModeOrAccessNodeWaitingAreaOverwritten(accessMode, waitingAreaSourceId, accessNode, getOverwrittenWaitingAreaSourceId);
        Collection<LinkSegment> accessLinkSegments = ZoningConverterUtils.findAccessEntryLinkSegmentsForWaitingArea(waitingAreaSourceId, waitingAreaGeometry, accessLink, accessLinkSourceId, accessNode, accessMode, countryName, mustAvoidCrossingTraffic, getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId, getOverwrittenWaitingAreaSourceId, geoUtils);
        return !accessLinkSegments.isEmpty();
    }

    public static Point findConnectoidLocationForWaitingAreaOnLinkSegment(String waitingAreaSourceId, Geometry waitingAreaGeometry, MacroscopicLinkSegment accessLinkSegment, String accessLinkSourceId, Mode accessMode, double maxAllowedDistanceMeters, Function<Node, String> getOverwrittenWaitingAreaSourceIdForNode, Function<Point, String> getOverwrittenWaitingAreaSourceIdForPoint, Function<String, String> getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId, String countryName, PlanitJtsCrsUtils geoUtils) {
        boolean isOverride = getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId != null && getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId.apply(waitingAreaSourceId) != null && getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId.apply(waitingAreaSourceId).equals(accessLinkSourceId);
        LineString accessLinkSegmentGeometry = accessLinkSegment.getParentLink().getGeometry();
        int startIndex = accessLinkSegment.isParentGeometryInSegmentDirection(false) ? 1 : 0;
        int endIndex = accessLinkSegment.isParentGeometryInSegmentDirection(false) ? accessLinkSegmentGeometry.getNumPoints() - 1 : accessLinkSegmentGeometry.getNumPoints() - 2;
        Coordinate closestExistingCoordinate = geoUtils.getClosestExistingLineStringCoordinateToGeometry(waitingAreaGeometry, accessLinkSegmentGeometry, startIndex, endIndex);
        double distanceToExistingCoordinateOnLinkInMeters = geoUtils.getClosestDistanceInMeters(closestExistingCoordinate, waitingAreaGeometry);
        if (accessLinkSegment.getDownstreamVertex().isPositionEqual2D(closestExistingCoordinate, 1.0E-6) && distanceToExistingCoordinateOnLinkInMeters < maxAllowedDistanceMeters) {
            if (ZoningConverterUtils.isPotentialAccessEntryLinkSegmentForWaitingArea(waitingAreaSourceId, waitingAreaGeometry, accessLinkSegment, accessLinkSourceId, accessLinkSegment.getDownstreamVertex(), accessMode, getOverwrittenWaitingAreaSourceIdForNode, getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId, countryName, geoUtils)) {
                return PlanitJtsUtils.createPoint((Coordinate)closestExistingCoordinate);
            }
            return null;
        }
        LineSegment lineSegmentForLocation = null;
        if (distanceToExistingCoordinateOnLinkInMeters < maxAllowedDistanceMeters) {
            Coordinate[] linkCoordinates = accessLinkSegmentGeometry.getCoordinates();
            int coordinateIndex = PlanitJtsUtils.getCoordinateIndexOf((Coordinate)closestExistingCoordinate, (Coordinate[])linkCoordinates);
            if (coordinateIndex <= 0 || coordinateIndex == accessLinkSegmentGeometry.getCoordinates().length - 1) {
                throw new PlanItRunTimeException("Unable to locate link internal location even though it is expected to exist when identifying connectoid location for waiting area %s", new Object[]{waitingAreaSourceId});
            }
            lineSegmentForLocation = new LineSegment(linkCoordinates[coordinateIndex - 1], linkCoordinates[coordinateIndex]);
        } else {
            LinearLocation projectedLinLocOnLink = PlanitEntityGeoUtils.extractClosestProjectedLinearLocationToGeometryFromEdge((Geometry)waitingAreaGeometry, (Edge)accessLinkSegment.getParentLink(), (PlanitJtsCrsUtils)geoUtils);
            Coordinate closestProjectedCoordinate = projectedLinLocOnLink.getCoordinate((Geometry)accessLinkSegmentGeometry);
            if (!closestExistingCoordinate.equals2D(closestProjectedCoordinate) && (isOverride || geoUtils.getClosestDistanceInMeters(closestProjectedCoordinate, waitingAreaGeometry) <= maxAllowedDistanceMeters)) {
                lineSegmentForLocation = new LineSegment(accessLinkSegmentGeometry.getCoordinates()[projectedLinLocOnLink.getSegmentIndex()], closestProjectedCoordinate);
            }
        }
        if (lineSegmentForLocation == null) {
            return null;
        }
        Coordinate chosenCoordinate = lineSegmentForLocation.getCoordinate(1);
        Point connectoidLocation = PlanitJtsUtils.createPoint((Coordinate)chosenCoordinate);
        if (isOverride) {
            return connectoidLocation;
        }
        boolean mustAvoidCrossingTraffic = ZoningConverterUtils.isAvoidCrossTrafficForAccessModeOrAccessNodeWaitingAreaOverwritten(accessMode, waitingAreaSourceId, connectoidLocation, getOverwrittenWaitingAreaSourceIdForPoint);
        if (!mustAvoidCrossingTraffic) {
            return connectoidLocation;
        }
        boolean isLeftOfWaitingArea = ZoningConverterUtils.isWaitingAreaLeftOfAccessLineSegment(waitingAreaGeometry, accessLinkSegment, lineSegmentForLocation, geoUtils);
        return isLeftOfWaitingArea == DrivingDirectionDefaultByCountry.isLeftHandDrive((String)countryName) ? connectoidLocation : null;
    }

    @Deprecated
    public static Point findConnectoidLocationForWaitingAreaOnLink(String waitingAreaSourceId, Geometry waitingAreaGeometry, MacroscopicLink accessLink, String accessLinkSourceId, Mode accessMode, double maxAllowedDistanceMeters, Function<Node, String> getOverwrittenWaitingAreaSourceIdForNode, Function<Point, String> getOverwrittenWaitingAreaSourceIdForPoint, Function<String, String> getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId, String countryName, PlanitJtsCrsUtils geoUtils) {
        LinearLocation projectedLinLocOnLink;
        Coordinate closestProjectedCoordinate;
        Coordinate closestExistingCoordinate = geoUtils.getClosestExistingLineStringCoordinateToGeometry(waitingAreaGeometry, accessLink.getGeometry());
        double distanceToExistingCoordinateOnLinkInMeters = geoUtils.getClosestDistanceInMeters(closestExistingCoordinate, waitingAreaGeometry);
        Point connectoidLocation = null;
        if (distanceToExistingCoordinateOnLinkInMeters < maxAllowedDistanceMeters) {
            if (accessLink.getVertexA().isPositionEqual2D(closestExistingCoordinate, 1.0E-6)) {
                if (ZoningConverterUtils.hasWaitingAreaPotentialAccessLinkSegmentForLinkNodeModeCombination(waitingAreaSourceId, waitingAreaGeometry, accessLink, accessLinkSourceId, accessLink.getNodeA(), accessMode, getOverwrittenWaitingAreaSourceIdForNode, getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId, countryName, geoUtils)) {
                    connectoidLocation = PlanitJtsUtils.createPoint((Coordinate)closestExistingCoordinate);
                }
            } else if (accessLink.getVertexB().isPositionEqual2D(closestExistingCoordinate, 1.0E-6)) {
                if (ZoningConverterUtils.hasWaitingAreaPotentialAccessLinkSegmentForLinkNodeModeCombination(waitingAreaSourceId, waitingAreaGeometry, accessLink, accessLinkSourceId, accessLink.getNodeB(), accessMode, getOverwrittenWaitingAreaSourceIdForNode, getOverwrittenAccessLinkSourceIdForWaitingAreaSourceId, countryName, geoUtils)) {
                    connectoidLocation = PlanitJtsUtils.createPoint((Coordinate)closestExistingCoordinate);
                }
            } else {
                int coordinateIndex = PlanitJtsUtils.getCoordinateIndexOf((Coordinate)closestExistingCoordinate, (Coordinate[])accessLink.getGeometry().getCoordinates());
                if (coordinateIndex <= 0 || coordinateIndex == accessLink.getGeometry().getCoordinates().length - 1) {
                    throw new PlanItRunTimeException("Unable to locate link internal location even though it is expected to exist when identifying connectoid location for waiting area %s", new Object[]{waitingAreaSourceId});
                }
                connectoidLocation = PlanitJtsUtils.createPoint((Coordinate)closestExistingCoordinate);
                if (!ZoningConverterUtils.isWaitingAreaAccessLinkSegmentInternalLocationModeCombinationDirectionallyValid(waitingAreaSourceId, waitingAreaGeometry, accessLink, connectoidLocation, accessMode, getOverwrittenWaitingAreaSourceIdForPoint, countryName, geoUtils)) {
                    connectoidLocation = null;
                }
            }
        }
        if (connectoidLocation == null && !closestExistingCoordinate.equals2D(closestProjectedCoordinate = (projectedLinLocOnLink = PlanitEntityGeoUtils.extractClosestProjectedLinearLocationToGeometryFromEdge((Geometry)waitingAreaGeometry, (Edge)accessLink, (PlanitJtsCrsUtils)geoUtils)).getCoordinate((Geometry)accessLink.getGeometry())) && !(geoUtils.getClosestDistanceInMeters(closestProjectedCoordinate, waitingAreaGeometry) > maxAllowedDistanceMeters)) {
            connectoidLocation = PlanitJtsUtils.createPoint((Coordinate)closestProjectedCoordinate);
        }
        return connectoidLocation;
    }

    public static DirectedConnectoid createAndRegisterDirectedConnectoid(Zoning zoning, TransferZone accessZone, boolean downstreamAccessNode, MacroscopicLinkSegment linkSegment, Set<Mode> allowedModes) {
        Set realAllowedModes = linkSegment.getAllowedModesFrom(allowedModes);
        if (realAllowedModes != null && !realAllowedModes.isEmpty()) {
            DirectedConnectoid connectoid = zoning.getTransferConnectoids().getFactory().registerNew(downstreamAccessNode, (LinkSegment)linkSegment, (Zone)accessZone, true, (Collection)realAllowedModes);
            return connectoid;
        }
        return null;
    }

    public static Collection<DirectedConnectoid> createAndRegisterDirectedConnectoids(Zoning zoning, TransferZone transferZone, Node accessNode, Iterable<? extends MacroscopicLinkSegment> linkSegments, Set<Mode> allowedModes) {
        HashSet<DirectedConnectoid> createdConnectoids = new HashSet<DirectedConnectoid>();
        IterableUtils.asStream(linkSegments).sorted(Comparator.comparing(IdAble::getId)).forEach(linkSegment -> {
            boolean downstreamAccessNode = linkSegment.isDownstreamNode(accessNode);
            if (!linkSegment.hasNode(accessNode)) {
                throw new PlanItRunTimeException("Chosen access node %s not attached to link segment %s", new Object[]{accessNode.getIdsAsString(), linkSegment.getIdsAsString()});
            }
            DirectedConnectoid newConnectoid = ZoningConverterUtils.createAndRegisterDirectedConnectoid(zoning, transferZone, downstreamAccessNode, linkSegment, allowedModes);
            if (newConnectoid != null) {
                createdConnectoids.add(newConnectoid);
            }
        });
        return createdConnectoids;
    }
}

