/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.converter.intermodal;

import java.util.logging.Logger;
import org.goplanit.converter.PairConverter;
import org.goplanit.converter.PairConverterReader;
import org.goplanit.converter.PairConverterWriter;
import org.goplanit.converter.intermodal.IntermodalReader;
import org.goplanit.converter.intermodal.IntermodalWriter;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.service.routed.RoutedServices;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.misc.Quadruple;
import org.goplanit.zoning.Zoning;

public class IntermodalConverter<T extends ServiceNetwork, U extends RoutedServices>
extends PairConverter<MacroscopicNetwork, Zoning> {
    private static final Logger LOGGER = Logger.getLogger(IntermodalConverter.class.getCanonicalName());

    protected IntermodalConverter(PairConverterReader<MacroscopicNetwork, Zoning> reader, PairConverterWriter<MacroscopicNetwork, Zoning> writer) {
        super(reader, writer);
    }

    protected IntermodalConverter(IntermodalReader<T, U> reader, IntermodalWriter<ServiceNetwork, RoutedServices> writer) {
        super(reader, writer);
    }

    @Override
    public void convert() throws PlanItException {
        LOGGER.info("Converting without services, invoke convertWithServices() if you wish to include services in this conversion");
        super.convert();
    }

    public void convertWithServices() throws PlanItException {
        IntermodalReader reader = (IntermodalReader)this.getReader();
        LOGGER.info(String.format("****************** [START] INTERMODAL CONVERTER WITH SERVICES: READ %s [START] ********************", reader.getTypeDescription()));
        Quadruple quadResult = reader.readWithServices();
        reader.reset();
        LOGGER.info(String.format("****************** [END]   INTERMODAL CONVERTER WITH SERVICES: READ %s [END]   ********************", reader.getTypeDescription()));
        IntermodalWriter writer = (IntermodalWriter)this.getWriter();
        LOGGER.info(String.format("****************** [START] INTERMODAL CONVERTER WITH SERVICES: WRITE %s [START] ********************", writer.getTypeDescription()));
        writer.writeWithServices((MacroscopicNetwork)quadResult.first(), (Zoning)quadResult.second(), (ServiceNetwork)quadResult.third(), (RoutedServices)quadResult.fourth());
        writer.reset();
        LOGGER.info(String.format("****************** [END]   INTERMODAL CONVERTER WITH SERVICES: WRITE %s [END]   ********************", writer.getTypeDescription()));
    }
}

